package com.biz.crm.mdm.business.sales.org.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.util.List;

/**
 * 销售组织表返回vo
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.9 20:57
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "销售组织表")
public class SalesOrgVo extends TenantFlagOpVo {

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String salesOrgName;
    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;
    /**
     * 销售组织层级
     */
    @ApiModelProperty("销售组织层级（字典mdm_sales_org_level）")
    private String salesOrgLevel;
    /**
     * 销售组织层级
     */
    @ApiModelProperty("销售组织层级（salesOrgLevel）")
    private String salesOrgLevelName;
    /**
     * 销售组织类型
     */
    @ApiModelProperty("销售组织类型（字典mdm_org_type）")
    private String salesOrgType;
    /**
     * 销售组织类型name
     */
    @ApiModelProperty("销售组织类型（orgType字段经过数据字典翻译后的值）")
    private String salesOrgTypeName;
    /**
     * 销售组织描述
     */
    @ApiModelProperty("销售组织描述")
    private String salesOrgDesc;
    /**
     * 上级销售组织编码
     */
    @ApiModelProperty("上级销售组织编码")
    private String parentCode;
    /**
     * 对应SAP销售组织编码
     */
    @ApiModelProperty("对应SAP销售组织编码")
    private String erpCode;

    /**
     * 上级销售组织名称
     */
    @ApiModelProperty("上级销售组织名称")
    private String parentName;

    /**
     * 规则code查询用
     */
    @ApiModelProperty("对应SAP销售组织编码成本中心编码")
    private String ruleCode;

    /**
     * 层级等级查询用
     */
    @ApiModelProperty("层级等级查询用")
    private Integer levelNum;
    /**
     * 子节点
     */
    @ApiModelProperty("fu")
    private SalesOrgVo parent;
    /**
     * 子节点
     */
    @ApiModelProperty("子节点")
    private List<SalesOrgVo> children;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元编码")
    private String businessUnitCode;

    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    @ApiModelProperty("对应上级SAP销售组织编码")
    private String parentErpCode;

    @ApiModelProperty("拼接")
    private String unionName;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;
}
