/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.sequese.local.demo.algorithm;

import com.biz.crm.common.sequese.sdk.generator.service.CrmSequeseGenerator;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;

@Component
public class CrmSequeseGeneratorByRedisYyyyMmDd
implements CrmSequeseGenerator<String> {
    private static final Logger log = LoggerFactory.getLogger(CrmSequeseGeneratorByRedisYyyyMmDd.class);
    private static final String KEY_FORMAT = "seq:code:%s";
    @Autowired
    private RedisTemplate redisTemplate;
    private static final String SEQ_FORMAT_TEMP = "%s-%010d";

    public void initAlgorithm() {
    }

    private String getFormatVal(long andIncrement) {
        String val = String.format(SEQ_FORMAT_TEMP, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"), andIncrement);
        return val;
    }

    public String nextVal(String subSystem, String bizCode) {
        String redisCounter = this.getRedisCounter(subSystem, bizCode);
        long andIncrement = this.addAndGet(redisCounter, 1);
        String val = this.getFormatVal(andIncrement);
        return val;
    }

    public String[] nextValArray(String subSystem, String bizCode, int seqNum) {
        if (seqNum < 1) {
            seqNum = 1;
        }
        String redisCounter = this.getRedisCounter(subSystem, bizCode);
        long lastSeqVal = this.addAndGet(redisCounter, seqNum);
        String[] batchNextVal = new String[seqNum];
        ++lastSeqVal;
        for (int idx = 0; idx < batchNextVal.length; ++idx) {
            batchNextVal[idx] = this.getFormatVal(lastSeqVal - (long)seqNum + (long)idx);
        }
        return batchNextVal;
    }

    public String currVal(String subSystem, String bizCode) {
        return null;
    }

    public String getKey(String subSystem, String bizCode) {
        String nowTimeStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String key = String.format("%s:%s:%s:%s", TenantUtils.getTenantCode(), subSystem.toUpperCase(), bizCode, nowTimeStr);
        return key;
    }

    public Date getKeyExpireAtDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public String getSequeseRuleCode() {
        return "REDIS\u7b97\u6cd5";
    }

    private String getRedisCounter(String subSystem, String bizCode) {
        String key = this.getKey(subSystem, bizCode);
        String redisCounter = String.format(KEY_FORMAT, key);
        return redisCounter;
    }

    private Long addAndGet(String redisCounter, int stepNum) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(redisCounter, (RedisOperations)this.redisTemplate);
        long addAndGet = entityIdCounter.addAndGet((long)stepNum);
        Date date = this.getKeyExpireAtDate();
        if (date != null && entityIdCounter.getExpire() == -1L) {
            entityIdCounter.expireAt(date);
        }
        return addAndGet;
    }
}

