/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.sequese.local.demo.service;

import com.biz.crm.common.sequese.sdk.generator.service.CrmBizSequenceServiceByInteger;
import com.biz.crm.common.sequese.sdk.generator.service.aigorithm.CrmSequeseGeneratorByDb;
import com.biz.crm.mdm.business.sequese.local.demo.config.BusinessSequeseConfig;
import com.biz.crm.mdm.business.sequese.sdk.demo.dto.CrmBizSequenceServiceByDemoDtoDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=10)
public class CrmBizSequenceServiceByDb
implements CrmBizSequenceServiceByInteger<CrmBizSequenceServiceByDemoDtoDb, CrmSequeseGeneratorByDb> {
    private static final Logger log = LoggerFactory.getLogger(CrmBizSequenceServiceByDb.class);
    @Autowired
    CrmSequeseGeneratorByDb generator;
    private static final String SEQ_FORMAT_TEMP = "demo3-%010d-%011d";

    public Logger getLogger() {
        return log;
    }

    public boolean match(Object obj) {
        return obj instanceof CrmBizSequenceServiceByDemoDtoDb;
    }

    public String getSeqInfoByBizCode() {
        return "MDM_DEMO_SEQ_DB";
    }

    public String getSeqInfoByColumnDesc() {
        return "\u5b57\u6bb5\u63cf\u8ff03";
    }

    public String getSeqInfoByModleName() {
        return "\u4effOracle\u5e8f\u5217";
    }

    public String generatorFormat(CrmBizSequenceServiceByDemoDtoDb dto, Integer sequese) {
        int demoId = dto.getDemoId();
        String nextVal = String.format(SEQ_FORMAT_TEMP, demoId, sequese);
        return nextVal;
    }

    public String getSubSystem() {
        return BusinessSequeseConfig.subsystem;
    }

    public String toString() {
        return "CrmBizSequenceServiceByDb(generator=" + this.getGenerator() + ")";
    }

    public CrmSequeseGeneratorByDb getGenerator() {
        return this.generator;
    }
}

