/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.sequese.local.demo.service;

import com.biz.crm.common.sequese.sdk.generator.service.CrmBizSequenceServiceByLong;
import com.biz.crm.common.sequese.sdk.generator.service.aigorithm.CrmSequeseGeneratorByRedis;
import com.biz.crm.mdm.business.sequese.local.demo.config.BusinessSequeseConfig;
import com.biz.crm.mdm.business.sequese.sdk.demo.dto.CrmBizSequenceServiceByDemoDtoRedis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=5)
public class CrmBizSequenceServiceByRedis
implements CrmBizSequenceServiceByLong<CrmBizSequenceServiceByDemoDtoRedis, CrmSequeseGeneratorByRedis> {
    private static final Logger log = LoggerFactory.getLogger(CrmBizSequenceServiceByRedis.class);
    @Autowired
    CrmSequeseGeneratorByRedis generator;
    private static final String SEQ_FORMAT_TEMP = "demo-redis-%08d-%010d";

    public Logger getLogger() {
        return log;
    }

    public boolean match(Object obj) {
        return obj instanceof CrmBizSequenceServiceByDemoDtoRedis;
    }

    public String getSeqInfoByBizCode() {
        return "MDM_DEMO_SEQ_REDIS";
    }

    public String getSeqInfoByColumnDesc() {
        return "\u5b57\u6bb5\u63cf\u8ff03";
    }

    public String getSeqInfoByModleName() {
        return "Redis\u7b97\u6cd5\uff0c10\u8fdb\u5236";
    }

    public String getSubSystem() {
        return BusinessSequeseConfig.subsystem;
    }

    public String generatorFormat(CrmBizSequenceServiceByDemoDtoRedis dto, Long sequese) {
        int demoId = dto.getDemoId();
        String nextVal = String.format(SEQ_FORMAT_TEMP, demoId, sequese);
        return nextVal;
    }

    public String toString() {
        return "CrmBizSequenceServiceByRedis(generator=" + this.getGenerator() + ")";
    }

    public CrmSequeseGeneratorByRedis getGenerator() {
        return this.generator;
    }
}

