/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.sequese.local.demo.service;

import com.biz.crm.common.sequese.sdk.generator.service.CrmBizSequenceServiceByString;
import com.biz.crm.mdm.business.sequese.local.demo.algorithm.CrmSequeseGeneratorByUuid;
import com.biz.crm.mdm.business.sequese.local.demo.config.BusinessSequeseConfig;
import com.biz.crm.mdm.business.sequese.sdk.demo.dto.CrmBizSequenceServiceByDemoDtoUuid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=20)
public class CrmBizSequenceServiceByUuid
implements CrmBizSequenceServiceByString<CrmBizSequenceServiceByDemoDtoUuid, CrmSequeseGeneratorByUuid> {
    private static final Logger log = LoggerFactory.getLogger(CrmBizSequenceServiceByUuid.class);
    @Autowired
    CrmSequeseGeneratorByUuid generator;
    private static final String SEQ_FORMAT_TEMP = "demo-UUID-%08d-%s";

    public boolean match(Object obj) {
        return obj instanceof CrmBizSequenceServiceByDemoDtoUuid;
    }

    public String getSeqInfoByBizCode() {
        return "MDM_DEMO_SEQ_UUID";
    }

    public String getSeqInfoByColumnDesc() {
        return "\u5b57\u6bb5\u63cf\u8ff04";
    }

    public String getSeqInfoByModleName() {
        return "\u9879\u76ee\u7ec4\u81ea\u5b9a\u4e49\u7b97\u6cd5";
    }

    public Logger getLogger() {
        return log;
    }

    public String getSubSystem() {
        return BusinessSequeseConfig.subsystem;
    }

    public String generatorFormat(CrmBizSequenceServiceByDemoDtoUuid dto, String sequese) {
        int demoId = dto.getDemoId();
        String nextVal = String.format(SEQ_FORMAT_TEMP, demoId, sequese);
        return nextVal;
    }

    public String toString() {
        return "CrmBizSequenceServiceByUuid(generator=" + this.getGenerator() + ")";
    }

    public CrmSequeseGeneratorByUuid getGenerator() {
        return this.generator;
    }
}

