package com.biz.crm.mdm.business.supplier.feign.feign;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.supplier.feign.feign.interal.SupplierVoFeignImpl;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = SupplierVoFeignImpl.class)
public interface SupplierVoFeign {

    @PostMapping(value = {"/v1/supplier/supplier/findByConditions"})
    Result<List<SupplierVo>> findByConditions(@RequestBody SupplierDto paginationDto);

    @PostMapping(value = {"/v1/supplier/supplier/findBySupplierCodes"})
    Result<List<SupplierVo>> findBySupplierCodes(@RequestBody List<String> supplierCodes);

    @ApiOperation(value = "查询分页列表")
    @PostMapping(value = {"/v1/supplier/supplier/findSupplierByConditions"})
    Result<Page<SupplierVo>> findSupplierByConditions(@RequestBody SupplierDto paginationDto);
}
