package com.biz.crm.mdm.business.supplier.feign.feign.interal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mdm.business.supplier.feign.feign.SupplierVoFeign;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class SupplierVoFeignImpl implements FallbackFactory<SupplierVoFeign> {
    @Override
    public SupplierVoFeign create(Throwable cause) {
        return new SupplierVoFeign() {
            @Override
            public Result<List<SupplierVo>> findByConditions(SupplierDto paginationDto) {
                throw new UnsupportedOperationException("条件查询供应商列表关系熔断");
            }

            @Override
            public Result<List<SupplierVo>> findBySupplierCodes(List<String> supplierCodes) {
                throw new UnsupportedOperationException("供应商编码查询供应商列表关系熔断");
            }

            @Override
            public Result<Page<SupplierVo>> findSupplierByConditions(SupplierDto paginationDto) {
                throw new UnsupportedOperationException("查询分页列表熔断");
            }

        };
    }
}
