package com.biz.crm.mdm.business.supplier.feign.service.interna;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierBankVo;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.google.common.collect.Lists;
import com.biz.crm.mdm.business.supplier.feign.feign.SupplierVoFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SupplierVoServiceImpl  implements SupplierVoService {

    @Autowired
    private SupplierVoFeign supplierVoFeign;

    @Override
    public Page<SupplierVo> findByConditions(Pageable pageable, SupplierDto dto) {
        dto.setPage(pageable.getPageNumber());
        dto.setSize(pageable.getPageSize());
        Result<Page<SupplierVo>> result = supplierVoFeign.findSupplierByConditions(dto);
        if(result.isSuccess()){
            return result.getResult();
        }
        return new Page<>(pageable.getPageNumber(),pageable.getPageSize());
    }

    @Override
    public List<SupplierVo> findByConditions(SupplierDto dto) {
        Result<List<SupplierVo>> conditions = supplierVoFeign.findByConditions(dto);
        if (conditions == null || CollectionUtil.isEmpty(conditions.getResult())){
            return Lists.newArrayList();
        }
        return conditions.getResult();
    }

    @Override
    public List<SupplierVo> findBySupplierCodes(List<String> supplierCodes) {
        Result<List<SupplierVo>> listResult = supplierVoFeign.findBySupplierCodes(supplierCodes);
        if (listResult == null || CollectionUtil.isEmpty(listResult.getResult())){
            return Lists.newArrayList();
        }
        return listResult.getResult();
    }

    @Override
    public Page<SupplierBankVo> findDetailById(Pageable pageable, SupplierDto supplierDto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SupplierVo create(SupplierVo supplierVo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SupplierVo update(SupplierVo supplierVo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void enableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDelFlagByIds(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page<SupplierBankVo> findDetailByCode(Pageable pageable, SupplierDto supplierDto) {
        throw new UnsupportedOperationException();
    }
}
