package com.biz.crm.mdm.business.supplier.local.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 供应商银行信息表
 *
 * @author LiuYiFan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SupplierEntity", description = "供应商银行信息表")
@TableName("mdm_supplier_bank")
@Entity
@Table(name = "mdm_supplier_bank", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "mdm_supplier_bank", comment = "供应商银行信息表")
public class SupplierBankEntity extends TenantFlagOpEntity {

    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    @TableField(value = "supplier_code")
    @Column(name = "supplier_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 供应商编码 '")
    private String supplierCode;

    /**
     * 银行卡号
     */
    @ApiModelProperty("银行卡号")
    @TableField(value = "bank_card")
    @Column(name = "bank_card", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 银行卡号 '")
    private String bankCard;

    /**
     * 开户行
     */
    @ApiModelProperty("开户行")
    @TableField(value = "bank_account")
    @Column(name = "bank_account", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 开户行 '")
    private String bankAccount;

    /**
     * 银联行号
     */
    @ApiModelProperty("银联行号")
    @TableField(value = "union_pay_bank_card")
    @Column(name = "union_pay_bank_card", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 银联行号 '")
    private String unionPayBankCard;

    /**
     * 联系人姓名
     */
    @ApiModelProperty("联系人姓名")
    @TableField(value = "contact_name")
    @Column(name = "contact_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 联系人姓名 '")
    private String contactName;

    /**
     * 利润中心
     */
    @ApiModelProperty("利润中心")
    @TableField(value = "profit_center")
    @Column(name = "profit_center", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 利润中心 '")
    private String profitCenter;

    /**
     * 利润中心
     */
    @ApiModelProperty("公司")
    @TableField(value = "company")
    @Column(name = "company", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 公司 '")
    private String company;

}
