package com.biz.crm.mdm.business.supplier.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.supplier.local.entity.SupplierBankEntity;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierBankVo;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 供应商管理表(Supplier)表数据库访问层
 *
 * @author makejava
 * @date 2022-11-23 15:26:20
 */
public interface SupplierBankMapper extends BaseMapper<SupplierBankEntity> {

    /**
     * 批量查询
     *
     * @param sqlStr
     * @return java.util.List<com.biz.crm.mdm.business.supplier.local.entity.SupplierBankEntity>
     * @author huojia
     * @date 2022/12/29 17:00
     **/
    List<SupplierBankEntity> listBySupplierCodes(@Param("sqlStr") String sqlStr);

    /**
     * 分页查询供应商银行信息
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.supplier.sdk.vo.SupplierBankVo>
     * @author huojia
     * @date 2022/12/30 9:59
     **/
    Page<SupplierBankVo> findByConditions(Page<SupplierVo> page, @Param("dto") SupplierDto dto);
}

