package com.biz.crm.mdm.business.supplier.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.supplier.local.entity.SupplierEntity;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierSelectDto;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 供应商管理表(Supplier)表数据库访问层
 *
 * @author makejava
 * @date 2022-11-23 15:26:20
 */
public interface SupplierMapper extends BaseMapper<SupplierEntity> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<SupplierVo> findByConditions(
            Page<SupplierVo> page, @Param("dto") SupplierDto dto);

    List<CommonSelectVo> findSupplierSelectList(@Param("dto") CommonSelectDto dto, @Param("limitSize") int limitSize);

    /**
     * 供应商下拉(可排除部分数据)
     *
     * @param dto 查询参数
     * @return List<CommonSelectVo>
     */
    List<CommonSelectVo> findSupplierSelectListByOut(@Param("dto") SupplierSelectDto dto, @Param("limitSize") int limitSize);

    /**
     * 批量查询供应商数据
     *
     * @param sqlStr
     * @return java.util.List<com.biz.crm.mdm.business.supplier.local.entity.SupplierEntity>
     * @author huojia
     * @date 2022/12/29 16:41
     **/
    List<SupplierEntity> findBySupplierCodes(@Param("sqlStr") String sqlStr);
}

