package com.biz.crm.mdm.business.supplier.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierLogEventDto;
import com.biz.crm.mdm.business.supplier.sdk.event.log.SupplierLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SupplierLogEventListenerImpl  implements SupplierLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 新增时日志记录
     * @param eventDto 供应商新旧vo对象
     */
    @Override
    public void onCreate(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }


    /**
     * 删除时日志记录
     * @param eventDto 供应商新旧vo对象
     */
    @Override
    public void onDelete(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }


    /**
     * 修改时日志记录
     * @param eventDto 供应商新旧vo对象
     */
    @Override
    public void onUpdate(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }


    /**
     * 启用时日志记录
     * @param eventDto 供应商新旧vo对象
     */
    @Override
    public void onEnable(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }


    /**
     * 禁用时日志记录
     * @param eventDto 供应商新旧vo对象
     */
    @Override
    public void onDisable(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }

    /**
     * 构建日志dto对象
     * @param crmBusinessLogDto 日志dto
     * @param eventDto 新旧vo对象
     */
    private void buildCrmBusinessLog(CrmBusinessLogDto crmBusinessLogDto, SupplierLogEventDto eventDto) {
        crmBusinessLogDto.setOnlyKey(eventDto.getNewest().getId());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(eventDto.getOriginal());
        crmBusinessLogDto.setNewObject(eventDto.getNewest());
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
