package com.biz.crm.mdm.business.supplier.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.supplier.local.entity.SupplierBankEntity;
import com.biz.crm.mdm.business.supplier.local.mapper.SupplierBankMapper;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierBankVo;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.util.SqlUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 供应商管理表(repository)
 *
 * @author makejava
 * @date 2022-11-23 15:26:23
 */
@Component
public class SupplierBankRepository extends ServiceImpl<SupplierBankMapper, SupplierBankEntity> {

    @Autowired(required = false)
    private SupplierBankMapper supplierBankMapper;

    /**
     * 根据供应商编码批量查询
     *
     * @param supplierCode
     * @return java.util.List<com.biz.crm.mdm.business.supplier.local.entity.SupplierBankEntity>
     * @author huojia
     * @date 2022/12/29 15:51
     **/
    public List<SupplierBankEntity> listBySupplierCode(String supplierCode) {
        if (StringUtils.isEmpty(supplierCode)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(SupplierBankEntity::getSupplierCode, supplierCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 批量删除
     *
     * @param supplierCodeList
     * @author huojia
     * @date 2022/12/29 16:56
     **/
    public void delBySupplierCodeList(List<String> supplierCodeList) {
        List<SupplierBankEntity> supplierBankEntityList = this.listBySupplierCodes(supplierCodeList);
        if (CollectionUtils.isEmpty(supplierBankEntityList)) {
            return;
        }
        supplierBankEntityList.forEach(supplierBankEntity -> {
            supplierBankEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        this.updateBatchById(supplierBankEntityList);
    }

    /**
     * 批量查询
     *
     * @param supplierCodeList
     * @return java.util.List<com.biz.crm.mdm.business.supplier.local.entity.SupplierBankEntity>
     * @author huojia
     * @date 2022/12/29 16:59
     **/
    private List<SupplierBankEntity> listBySupplierCodes(List<String> supplierCodeList) {
        if (CollectionUtils.isEmpty(supplierCodeList)) {
            return null;
        }
        String sqlIn500 = SqlUtil.setSqlIn500(supplierCodeList, "supplier_code", true);
        return supplierBankMapper.listBySupplierCodes(sqlIn500);
    }

    /**
     * 分页查询供应商银行信息
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.supplier.sdk.vo.SupplierBankVo>
     * @author huojia
     * @date 2022/12/30 9:58
     **/
    public Page<SupplierBankVo> findByConditions(Page<SupplierVo> page, SupplierDto dto) {
        return supplierBankMapper.findByConditions(page, dto);
    }
}
