package com.biz.crm.mdm.business.supplier.local.repository;

import com.alibaba.druid.util.MySqlUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.supplier.local.entity.SupplierEntity;
import com.biz.crm.mdm.business.supplier.local.mapper.SupplierMapper;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierSelectDto;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.constant.CommonSelectConstant;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.util.SqlUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;

/**
 * 供应商管理表(repository)
 *
 * @author makejava
 * @date 2022-11-23 15:26:23
 */
@Component
public class SupplierRepository extends ServiceImpl<SupplierMapper, SupplierEntity> {

    @Autowired(required = false)
    private SupplierMapper supplierMapper;

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<SupplierVo> findByConditions(Page<SupplierVo> page, SupplierDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public SupplierEntity findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<SupplierEntity> findByIds(List<String> ids) {
        return this.lambdaQuery().in(SupplierEntity::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(SupplierEntity::getId, ids)
                .set(SupplierEntity::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(SupplierEntity::getId, ids)
                .set(SupplierEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }

    /**
     * 条件查询
     *
     * @param dto 条件dto
     * @return 供应商列表
     */
    public List<SupplierEntity> findByConditions(SupplierDto dto) {

        return this.lambdaQuery()
                .eq(SupplierEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(StringUtils.isNotEmpty(dto.getSupplierCode()), SupplierEntity::getSupplierCode, dto.getSupplierCode())
                .eq(StringUtils.isNotEmpty(dto.getSupplierName()), SupplierEntity::getSupplierName, dto.getSupplierName())
                .eq(StringUtils.isNotEmpty(dto.getBankCard()), SupplierEntity::getBankCard, dto.getBankCard())
                .eq(StringUtils.isNotEmpty(dto.getBankAccount()), SupplierEntity::getBankAccount, dto.getBankAccount())
                .eq(StringUtils.isNotEmpty(dto.getUnionPayBankCard()), SupplierEntity::getUnionPayBankCard, dto.getUnionPayBankCard())
                .eq(StringUtils.isNotEmpty(dto.getContactPhone()), SupplierEntity::getContactPhone, dto.getContactPhone())
                .eq(StringUtils.isNotEmpty(dto.getContactName()), SupplierEntity::getContactName, dto.getContactName())
                .list();
    }


    /**
     * 批量查询
     *
     * @param supplierCodes
     * @return java.util.List<com.biz.crm.mdm.business.supplier.local.entity.SupplierEntity>
     * @author huojia
     * @date 2022/12/29 16:07
     **/
    public List<SupplierEntity> findBySupplierCodes(List<String> supplierCodes) {
        String sqlIn500 = SqlUtil.setSqlIn500(supplierCodes, "supplier_code", true);
        List<SupplierEntity> supplierEntities = supplierMapper.findBySupplierCodes(sqlIn500);
        return this.lambdaQuery()
                .eq(SupplierEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(SupplierEntity::getSupplierCode, supplierCodes)
                .list();
    }

    /**
     * 供应商下拉
     *
     * @param dto 终端渠道查询参数
     */
    public List<CommonSelectVo> findSupplierSelectList(CommonSelectDto dto) {
        if (StringUtils.isNotEmpty(dto.getSelectedCode())) {
            List<String> selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return baseMapper.findSupplierSelectList(dto, CommonSelectConstant.COMMON_SELECT_DEFAULT_SIZE);
    }

    /**
     * 供应商下拉(可排除部分数据)
     *
     * @param dto 查询参数
     * @return List<CommonSelectVo>
     */
    public List<CommonSelectVo> findSupplierSelectListByOut(SupplierSelectDto dto) {
        return baseMapper.findSupplierSelectListByOut(dto, CommonSelectConstant.COMMON_SELECT_DEFAULT_SIZE);
    }

    public SupplierEntity findBySupplierCode(String supplierCode) {

        return this.lambdaQuery().eq(SupplierEntity::getSupplierCode,supplierCode).one();
    }
}
