package com.biz.crm.mdm.business.supplier.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierSelectDto;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 供应商管理表(Supplier)表服务接口
 *
 * @author makejava
 * @date 2022-11-23 15:26:54
 */
public interface SupplierService {

    /**
     * 批量拉取 MDG 供应商数据
     *
     * @param dto
     * @author huojia
     * @date 2022/12/5 21:37
     **/
    void pullSupplierList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取 MDG 供应商银行数据
     *
     * @param dto
     * @author huojia
     * @date 2022/12/6 16:37
     **/
    void pullSupplierBankList(MasterDataMdgBaseDto dto);

    /**
     * 供应商下拉
     *
     * @param dto 终端渠道查询参数
     */
    List<CommonSelectVo> findSupplierSelectList(CommonSelectDto dto);

    /**
     * 供应商下拉(可排除部分数据)
     *
     * @param dto 查询参数
     * @return List<CommonSelectVo>
     */
    List<CommonSelectVo> findSupplierSelectListByOut(SupplierSelectDto dto);

}
