/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.supplier.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.supplier.local.service.SupplierService;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierSelectDto;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierBankVo;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u7ba1\u7406\u8868"})
@RestController
@RequestMapping(value={"/v1/supplier/supplier"})
public class SupplierController {
    private static final Logger log = LoggerFactory.getLogger(SupplierController.class);
    @Autowired(required=false)
    private SupplierService supplierService;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<SupplierVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, SupplierDto paginationDto) {
        try {
            Page result = this.supplierVoService.findByConditions(pageable, paginationDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"findSupplierByConditions"})
    Result<Page<SupplierVo>> findSupplierByConditions(@RequestBody SupplierDto paginationDto) {
        try {
            PageRequest pageable = PageRequest.of((int)paginationDto.getPage(), (int)paginationDto.getSize());
            Page result = this.supplierVoService.findByConditions((Pageable)pageable, paginationDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c9\u53d6 MDG \u4f9b\u5e94\u5546\u6570\u636e")
    @PostMapping(value={"/pullSupplierList"})
    public Result<?> pullSupplierList(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.supplierService.pullSupplierList(dto);
            return Result.ok((String)"\u6279\u91cf\u62c9\u53d6 MDG \u4f9b\u5e94\u5546\u6570\u636e\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c9\u53d6 MDG \u4f9b\u5e94\u5546\u94f6\u884c\u6570\u636e")
    @PostMapping(value={"/pullSupplierBankList"})
    public Result<?> pullSupplierBankList(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.supplierService.pullSupplierBankList(dto);
            return Result.ok((String)"\u6279\u91cf\u62c9\u53d6 MDG \u4f9b\u5e94\u5546\u6570\u636e\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/findByConditions"})
    public Result<List<SupplierVo>> findByConditions(@RequestBody SupplierDto paginationDto) {
        try {
            List result = this.supplierVoService.findByConditions(paginationDto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/findBySupplierCodes"})
    public Result<List<SupplierVo>> findBySupplierCodes(@RequestBody List<String> supplierCodes) {
        try {
            List result = this.supplierVoService.findBySupplierCodes(supplierCodes);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<Page<SupplierBankVo>> findDetailById(@PageableDefault(value=50) Pageable pageable, SupplierDto supplierDto) {
        try {
            Page page = this.supplierVoService.findDetailById(pageable, supplierDto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309code\u67e5\u8be2\u8be6\u60c5\u4f9b\u5e94\u5546")
    @GetMapping(value={"/findDetailByCode"})
    public Result<Page<SupplierBankVo>> findDetailByCode(@PageableDefault(value=50) Pageable pageable, SupplierDto supplierDto) {
        try {
            Page page = this.supplierVoService.findDetailByCode(pageable, supplierDto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<SupplierVo> create(@RequestBody SupplierVo supplierVo) {
        try {
            SupplierVo current = this.supplierVoService.create(supplierVo);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<SupplierVo> update(@RequestBody SupplierVo supplierVo) {
        try {
            SupplierVo current = this.supplierVoService.update(supplierVo);
            return Result.ok((Object)current);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.supplierVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.supplierVoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.supplierVoService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u4e0b\u62c9")
    @PostMapping(value={"findSupplierSelectList"})
    public Result<List<CommonSelectVo>> findSupplierSelectList(@ApiParam(name="CommonSelectDto", value="\u67e5\u8be2\u53c2\u6570") @RequestBody CommonSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.supplierService.findSupplierSelectList(dto);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u4e0b\u62c9(\u53ef\u6392\u9664\u90e8\u5206\u6570\u636e)")
    @PostMapping(value={"findSupplierSelectListByOut"})
    public Result<List<CommonSelectVo>> findSupplierSelectListByOut(@ApiParam(name="dto", value="\u67e5\u8be2\u53c2\u6570") @RequestBody SupplierSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.supplierService.findSupplierSelectListByOut(dto);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

