/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.supplier.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierLogEventDto;
import com.biz.crm.mdm.business.supplier.sdk.event.log.SupplierLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SupplierLogEventListenerImpl
implements SupplierLogEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }

    public void onDelete(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }

    public void onUpdate(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }

    public void onEnable(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }

    public void onDisable(SupplierLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }

    private void buildCrmBusinessLog(CrmBusinessLogDto crmBusinessLogDto, SupplierLogEventDto eventDto) {
        crmBusinessLogDto.setOnlyKey(eventDto.getNewest().getId());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)eventDto.getOriginal());
        crmBusinessLogDto.setNewObject((Object)eventDto.getNewest());
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}

