/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.supplier.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.supplier.local.entity.SupplierBankEntity;
import com.biz.crm.mdm.business.supplier.local.mapper.SupplierBankMapper;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierBankVo;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.util.SqlUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SupplierBankRepository
extends ServiceImpl<SupplierBankMapper, SupplierBankEntity> {
    @Autowired(required=false)
    private SupplierBankMapper supplierBankMapper;

    public List<SupplierBankEntity> listBySupplierCode(String supplierCode) {
        if (StringUtils.isEmpty((CharSequence)supplierCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SupplierBankEntity::getSupplierCode, (Object)supplierCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void delBySupplierCodeList(List<String> supplierCodeList) {
        List<SupplierBankEntity> supplierBankEntityList = this.listBySupplierCodes(supplierCodeList);
        if (CollectionUtils.isEmpty(supplierBankEntityList)) {
            return;
        }
        supplierBankEntityList.forEach(supplierBankEntity -> supplierBankEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.updateBatchById(supplierBankEntityList);
    }

    private List<SupplierBankEntity> listBySupplierCodes(List<String> supplierCodeList) {
        if (CollectionUtils.isEmpty(supplierCodeList)) {
            return null;
        }
        String sqlIn500 = SqlUtil.setSqlIn500(supplierCodeList, (String)"supplier_code", (boolean)true);
        return this.supplierBankMapper.listBySupplierCodes(sqlIn500);
    }

    public Page<SupplierBankVo> findByConditions(Page<SupplierVo> page, SupplierDto dto) {
        return this.supplierBankMapper.findByConditions(page, dto);
    }
}

