/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.supplier.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.supplier.local.entity.SupplierEntity;
import com.biz.crm.mdm.business.supplier.local.mapper.SupplierMapper;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierSelectDto;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.util.SqlUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SupplierRepository
extends ServiceImpl<SupplierMapper, SupplierEntity> {
    @Autowired(required=false)
    private SupplierMapper supplierMapper;

    public Page<SupplierVo> findByConditions(Page<SupplierVo> page, SupplierDto dto) {
        return ((SupplierMapper)this.baseMapper).findByConditions(page, dto);
    }

    public SupplierEntity findById(String id) {
        return (SupplierEntity)((Object)((SupplierMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<SupplierEntity> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<SupplierEntity> findByConditions(SupplierDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSupplierCode()), SupplierEntity::getSupplierCode, (Object)dto.getSupplierCode())).eq(StringUtils.isNotEmpty((CharSequence)dto.getSupplierName()), SupplierEntity::getSupplierName, (Object)dto.getSupplierName())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBankCard()), SupplierEntity::getBankCard, (Object)dto.getBankCard())).eq(StringUtils.isNotEmpty((CharSequence)dto.getBankAccount()), SupplierEntity::getBankAccount, (Object)dto.getBankAccount())).eq(StringUtils.isNotEmpty((CharSequence)dto.getUnionPayBankCard()), SupplierEntity::getUnionPayBankCard, (Object)dto.getUnionPayBankCard())).eq(StringUtils.isNotEmpty((CharSequence)dto.getContactPhone()), SupplierEntity::getContactPhone, (Object)dto.getContactPhone())).eq(StringUtils.isNotEmpty((CharSequence)dto.getContactName()), SupplierEntity::getContactName, (Object)dto.getContactName())).list();
    }

    public List<SupplierEntity> findBySupplierCodes(List<String> supplierCodes) {
        String sqlIn500 = SqlUtil.setSqlIn500(supplierCodes, (String)"supplier_code", (boolean)true);
        List<SupplierEntity> supplierEntities = this.supplierMapper.findBySupplierCodes(sqlIn500);
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(SupplierEntity::getSupplierCode, supplierCodes)).list();
    }

    public List<CommonSelectVo> findSupplierSelectList(CommonSelectDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            List selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return ((SupplierMapper)this.baseMapper).findSupplierSelectList(dto, 50);
    }

    public List<CommonSelectVo> findSupplierSelectListByOut(SupplierSelectDto dto) {
        return ((SupplierMapper)this.baseMapper).findSupplierSelectListByOut(dto, 50);
    }

    public SupplierEntity findBySupplierCode(String supplierCode) {
        return (SupplierEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SupplierEntity::getSupplierCode, (Object)supplierCode)).one());
    }
}

