/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.supplier.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.supplier.local.entity.SupplierBankEntity;
import com.biz.crm.mdm.business.supplier.local.entity.SupplierEntity;
import com.biz.crm.mdm.business.supplier.local.repository.SupplierBankRepository;
import com.biz.crm.mdm.business.supplier.local.repository.SupplierRepository;
import com.biz.crm.mdm.business.supplier.local.service.SupplierService;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierSelectDto;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSupplierBankVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSupplierVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SupplierServiceImpl
implements SupplierService {
    private static final Logger log = LoggerFactory.getLogger(SupplierServiceImpl.class);
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private MasterDataMdgService masterDataMdgService;
    @Autowired(required=false)
    private SupplierRepository supplierRepository;
    @Autowired(required=false)
    private SupplierBankRepository supplierBankRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullSupplierList(MasterDataMdgBaseDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageNum())) {
            dto.setPageNum("1");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("400");
        }
        boolean lock = true;
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        if (!StringUtils.isEmpty((CharSequence)dto.getDs())) {
            dto.setDs(lockKey);
        }
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            List masterDataMdgSupplierVos = this.masterDataMdgService.pullSupplierList(dto);
            if (CollectionUtils.isEmpty((Collection)masterDataMdgSupplierVos)) {
                return;
            }
            List<SupplierEntity> pullList = this.supplierValidate(masterDataMdgSupplierVos);
            List<String> supplierCodeList = pullList.stream().map(SupplierEntity::getSupplierCode).collect(Collectors.toList());
            List<SupplierEntity> bySupplierCodes = this.supplierRepository.findBySupplierCodes(supplierCodeList);
            if (CollectionUtils.isEmpty(bySupplierCodes)) {
                this.saveOrUpdateBatch(pullList, null);
                return;
            }
            ArrayList<SupplierEntity> saveList = new ArrayList<SupplierEntity>();
            ArrayList<SupplierEntity> updateList = new ArrayList<SupplierEntity>();
            Map map = bySupplierCodes.stream().collect(Collectors.toMap(SupplierEntity::getSupplierCode, Function.identity()));
            pullList.forEach(pull -> {
                if (map.containsKey(pull.getSupplierCode())) {
                    SupplierEntity supplierEntity = (SupplierEntity)((Object)((Object)map.get(pull.getSupplierCode())));
                    supplierEntity.setSupplierName(pull.getSupplierName());
                    supplierEntity.setContactPhone(pull.getContactPhone());
                    updateList.add(supplierEntity);
                } else {
                    saveList.add((SupplierEntity)((Object)pull));
                }
            });
            this.saveOrUpdateBatch(saveList, updateList);
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void saveOrUpdateBatch(List<SupplierEntity> saveList, List<SupplierEntity> updateList) {
        if (!CollectionUtils.isEmpty(saveList)) {
            this.supplierRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.supplierRepository.updateBatchById(updateList);
        }
    }

    private List<SupplierEntity> supplierValidate(List<MasterDataMdgSupplierVo> masterDataMdgSupplierVos) {
        HashMap codeMap = new HashMap(1000000);
        ArrayList<SupplierEntity> pullList = new ArrayList<SupplierEntity>();
        masterDataMdgSupplierVos.forEach(masterDataMdgSupplierVo -> {
            if (StringUtils.isEmpty((CharSequence)masterDataMdgSupplierVo.getLifnr())) {
                throw new RuntimeException(JSON.toJSONString((Object)("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a\uff1a" + JSON.toJSONString((Object)masterDataMdgSupplierVo))));
            }
            SupplierEntity supplierEntity = new SupplierEntity();
            List supplierVos = Optional.ofNullable(codeMap.get(masterDataMdgSupplierVo.getLifnr())).orElse(new ArrayList());
            supplierVos.add(masterDataMdgSupplierVo);
            if (supplierVos.size() > 1) {
                throw new RuntimeException("\u6570\u636e\uff1a" + JSON.toJSONString((Object)supplierVos) + "\u91cd\u590d\u62c9\u53d6\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            codeMap.put(masterDataMdgSupplierVo.getLifnr(), supplierVos);
            supplierEntity.setSupplierCode(masterDataMdgSupplierVo.getLifnr());
            supplierEntity.setSupplierName(masterDataMdgSupplierVo.getName1());
            supplierEntity.setContactPhone(masterDataMdgSupplierVo.getTelf1());
            supplierEntity.setTenantCode(TenantUtils.getTenantCode());
            supplierEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            pullList.add(supplierEntity);
        });
        return pullList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullSupplierBankList(MasterDataMdgBaseDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            dto = new MasterDataMdgBaseDto();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageNum())) {
            dto.setPageNum("1");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getPageSize())) {
            dto.setPageSize("400");
        }
        boolean lock = true;
        String lockKey = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        if (!StringUtils.isEmpty((CharSequence)dto.getDs())) {
            dto.setDs(lockKey);
        }
        try {
            lock = this.lock(lockKey);
            if (!lock) {
                return;
            }
            List masterDataMdgSupplierBankVos = this.masterDataMdgService.pullSupplierBankList(dto);
            if (CollectionUtils.isEmpty((Collection)masterDataMdgSupplierBankVos)) {
                return;
            }
            List<String> supplierCodeList = masterDataMdgSupplierBankVos.stream().map(MasterDataMdgSupplierBankVo::getLifnr).filter(Objects::nonNull).collect(Collectors.toList());
            List<SupplierEntity> supplierEntities = this.supplierRepository.findBySupplierCodes(supplierCodeList);
            if (CollectionUtils.isEmpty(supplierEntities)) {
                return;
            }
            ArrayList<SupplierBankEntity> pullList = new ArrayList<SupplierBankEntity>();
            masterDataMdgSupplierBankVos.forEach(masterDataMdgSupplierBankVo -> {
                if (StringUtils.isEmpty((CharSequence)masterDataMdgSupplierBankVo.getLifnr())) {
                    throw new RuntimeException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a\uff1a" + JSON.toJSONString((Object)masterDataMdgSupplierBankVo));
                }
                SupplierBankEntity supplierBankEntity = new SupplierBankEntity();
                supplierBankEntity.setSupplierCode(masterDataMdgSupplierBankVo.getLifnr());
                supplierBankEntity.setBankCard(masterDataMdgSupplierBankVo.getBankn());
                supplierBankEntity.setBankAccount(masterDataMdgSupplierBankVo.getBanka());
                supplierBankEntity.setUnionPayBankCard(masterDataMdgSupplierBankVo.getBankl());
                supplierBankEntity.setContactName(masterDataMdgSupplierBankVo.getKoinh());
                supplierBankEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                supplierBankEntity.setTenantCode(TenantUtils.getTenantCode());
                supplierBankEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                pullList.add(supplierBankEntity);
            });
            this.saveOrUpdateMdgBatch(supplierCodeList, pullList);
        }
        finally {
            if (lock) {
                this.unLock(lockKey);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void saveOrUpdateMdgBatch(List<String> supplierCodeList, List<SupplierBankEntity> pullList) {
        if (!CollectionUtils.isEmpty(supplierCodeList)) {
            this.supplierBankRepository.delBySupplierCodeList(supplierCodeList);
        }
        if (!CollectionUtils.isEmpty(pullList)) {
            this.supplierBankRepository.saveBatch(pullList);
        }
    }

    public boolean lock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u4f9b\u5e94\u5546\u52a0\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.redisMutexService.tryLock("supplier_lock:lock:" + yearMonthDay, TimeUnit.HOURS, 12);
    }

    public void unLock(String yearMonthDay) {
        if (StringUtils.isEmpty((CharSequence)yearMonthDay)) {
            throw new RuntimeException("\u62c9\u53d6\u4f9b\u5e94\u5546\u89e3\u9501\u5931\u8d25\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.redisMutexService.unlock("supplier_lock:lock:" + yearMonthDay);
    }

    @Override
    public List<CommonSelectVo> findSupplierSelectList(CommonSelectDto dto) {
        return this.supplierRepository.findSupplierSelectList(dto);
    }

    @Override
    public List<CommonSelectVo> findSupplierSelectListByOut(SupplierSelectDto dto) {
        if (Objects.isNull(dto)) {
            dto = new SupplierSelectDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.supplierRepository.findSupplierSelectListByOut(dto);
    }
}

