/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.supplier.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.supplier.local.entity.SupplierEntity;
import com.biz.crm.mdm.business.supplier.local.repository.SupplierBankRepository;
import com.biz.crm.mdm.business.supplier.local.repository.SupplierRepository;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierLogEventDto;
import com.biz.crm.mdm.business.supplier.sdk.event.SupplierEventListener;
import com.biz.crm.mdm.business.supplier.sdk.event.log.SupplierLogEventListener;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierBankVo;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="supplierService")
public class SupplierVoServiceImpl
implements SupplierVoService {
    private static final Logger log = LoggerFactory.getLogger(SupplierVoServiceImpl.class);
    @Autowired(required=false)
    private SupplierBankRepository supplierBankRepository;
    @Autowired(required=false)
    private SupplierRepository supplierRepository;
    @Autowired(required=false)
    private List<SupplierEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<SupplierVo> findByConditions(Pageable pageable, SupplierDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SupplierDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.supplierRepository.findByConditions((Page<SupplierVo>)page, dto);
    }

    public List<SupplierVo> findByConditions(SupplierDto dto) {
        if (dto == null) {
            return Lists.newArrayList();
        }
        List<SupplierEntity> supplierEntities = this.supplierRepository.findByConditions(dto);
        if (CollectionUtils.isEmpty(supplierEntities)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(supplierEntities, SupplierEntity.class, SupplierVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<SupplierVo> findBySupplierCodes(List<String> supplierCodes) {
        if (CollectionUtils.isEmpty(supplierCodes)) {
            return Lists.newArrayList();
        }
        List<SupplierEntity> supplierEntities = this.supplierRepository.findBySupplierCodes(supplierCodes);
        if (CollectionUtils.isEmpty(supplierEntities)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(supplierEntities, SupplierEntity.class, SupplierVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public Page<SupplierBankVo> findDetailById(Pageable pageable, SupplierDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getId())) {
            return null;
        }
        SupplierEntity supplier = this.supplierRepository.findById(dto.getId());
        if (supplier == null) {
            return null;
        }
        dto.setSupplierCode(supplier.getSupplierCode());
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SupplierDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.supplierBankRepository.findByConditions((Page<SupplierVo>)page, dto);
    }

    public Page<SupplierBankVo> findDetailByCode(Pageable pageable, SupplierDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getSupplierCode())) {
            return null;
        }
        SupplierEntity supplier = this.supplierRepository.findBySupplierCode(dto.getSupplierCode());
        if (supplier == null) {
            return null;
        }
        dto.setSupplierCode(supplier.getSupplierCode());
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SupplierDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.supplierBankRepository.findByConditions((Page<SupplierVo>)page, dto);
    }

    @Transactional
    public SupplierVo create(SupplierVo supplierVo) {
        this.createValidation(supplierVo);
        supplierVo.setTenantCode(TenantUtils.getTenantCode());
        supplierVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        supplierVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        SupplierEntity supplier = (SupplierEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)supplierVo, SupplierEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.supplierRepository.saveOrUpdate((Object)supplier);
        supplierVo.setId(supplier.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (SupplierEventListener supplierEventListener : this.eventListeners) {
                supplierEventListener.onCreate(supplierVo);
            }
        }
        SupplierLogEventDto logEventDto = new SupplierLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(supplierVo);
        SerializableBiConsumer & Serializable onCreate = SupplierLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SupplierLogEventListener.class, (SerializableBiConsumer)onCreate);
        return supplierVo;
    }

    @Transactional
    public SupplierVo update(SupplierVo supplierVo) {
        this.updateValidation(supplierVo);
        String currentId = supplierVo.getId();
        SupplierEntity current = this.supplierRepository.findById(currentId);
        current = (SupplierEntity)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        SupplierVo oldVo = (SupplierVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, SupplierVo.class, HashSet.class, ArrayList.class, new String[0]);
        current.setSupplierName(supplierVo.getSupplierName());
        current.setBankCard(supplierVo.getBankCard());
        current.setBankAccount(supplierVo.getBankAccount());
        current.setUnionPayBankCard(supplierVo.getUnionPayBankCard());
        current.setContactName(supplierVo.getContactName());
        current.setContactPhone(supplierVo.getContactPhone());
        this.supplierRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (SupplierEventListener supplierEventListener : this.eventListeners) {
                supplierEventListener.onUpdate(oldVo, supplierVo);
            }
        }
        SupplierLogEventDto logEventDto = new SupplierLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(supplierVo);
        SerializableBiConsumer & Serializable onUpdate = SupplierLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, SupplierLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return supplierVo;
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.supplierRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.supplierRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.supplierRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(SupplierVo supplierVo) {
        this.validation(supplierVo);
    }

    private void updateValidation(SupplierVo supplierVo) {
        this.validation(supplierVo);
    }

    private void validation(SupplierVo supplierVo) {
        Validate.notEmpty((CharSequence)supplierVo.getSupplierCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)supplierVo.getSupplierName(), (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

