package com.biz.crm.mdm.business.supplier.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商管理表dto
 *
 * @author makejava
 * @date 2022-11-23 15:26:54
 */
@Data
@ApiModel(value = "SupplierDto", description = "供应商管理表dto")
public class SupplierDto extends TenantFlagOpDto {

    private int page;
    private int size;
    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String supplierCode;


    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商名称")
    private String supplierName;


    /**
     * 银行卡号
     */
    @ApiModelProperty("银行卡号")
    private String bankCard;



    /**
     * 开户行
     */
    @ApiModelProperty("开户行")
    private String bankAccount;


    /**
     * 银联行号
     */
    @ApiModelProperty("银联行号")
    private String unionPayBankCard;



    /** 联系人姓名 */
    @ApiModelProperty("联系人姓名")
    private String contactName;


    /** 联系人电话 */
    @ApiModelProperty("联系人电话")
    private String contactPhone;

    /**
     * 利润中心
     */
    @ApiModelProperty("利润中心")
    private String profitCenter;

    /**
     * 公司
     */
    @ApiModelProperty("公司")
    private String company;


}

