package com.biz.crm.mdm.business.supplier.sdk.event;

import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;

import java.util.List;

/**
 * 供应商管理表变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-23 15:26:54
 */
public interface SupplierEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(SupplierVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(SupplierVo oldVo, SupplierVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<SupplierVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<SupplierVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<SupplierVo> list);
}

