package com.biz.crm.mdm.business.supplier.sdk.event.log;

import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * 供应商管理表变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-23 15:26:54
 */
public interface SupplierLogEventListener extends NebulaEvent {


    /**
     * 创建日志事件
     */
    void onCreate(SupplierLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(SupplierLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(SupplierLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(SupplierLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto
     */
    void onDisable(SupplierLogEventDto eventDto);

}

