package com.biz.crm.mdm.business.supplier.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import java.util.List;

import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierBankVo;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import org.springframework.data.domain.Pageable;

/**
 * 供应商管理表(Supplier)表服务接口
 *
 * @author makejava
 * @date 2022-11-23 15:26:54
 */
public interface SupplierVoService {

    /**
     * 分页条件查询
     *
     * @param pageable 分页参数
     * @param dto 查询条件
     * @return 供应商列表
     */
    Page<SupplierVo> findByConditions(Pageable pageable, SupplierDto dto);

    /**
     * 条件查询
     *
     * @param dto 查询条件
     * @return 供应商列表
     */
    List<SupplierVo> findByConditions(SupplierDto dto);

    /**
     * 根据供应商编码查询
     * @param supplierCodes 供应商编码集合
     * @return
     */
    List<SupplierVo> findBySupplierCodes(List<String> supplierCodes);

    /**
     * 按id查询详情供应商
     *
     * @param supplierDto 请求参数
     * @return 供应商VO
     */
    Page<SupplierBankVo> findDetailById(Pageable pageable, SupplierDto supplierDto);

    /**
     * 创建供应商
     *
     * @param supplierVo 供应商VO
     * @return 创建成功的供应商VO
     */
    SupplierVo create(SupplierVo supplierVo);

    /**
     * 更新供应商信息
     *
     * @param supplierVo new供应商VO
     * @return 更新结果
     */
    SupplierVo update(SupplierVo supplierVo);

    /**
     * 按id集合启用
     *
     * @param ids 主键主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids 禁用主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids 删除主键列表
     */
    void updateDelFlagByIds(List<String> ids);

    /**
     * 按code查询详情供应商
     * @param pageable
     * @param supplierDto
     * @return
     */
    Page<SupplierBankVo> findDetailByCode(Pageable pageable, SupplierDto supplierDto);
}
