package com.biz.crm.mdm.business.supplier.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 供应商管理表vo
 *
 * @author makejava
 * @date 2022-11-23 15:26:54
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "供应商管理表Vo")
public class SupplierBankVo extends TenantFlagOpVo {

    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String supplierCode;

    /**
     * 银行卡号
     */
    @ApiModelProperty("银行卡号")
    private String bankCard;

    /**
     * 开户行
     */
    @ApiModelProperty("开户行")
    private String bankAccount;

    /**
     * 银联行号
     */
    @ApiModelProperty("银联行号")
    private String unionPayBankCard;

    /**
     * 联系人姓名
     */
    @ApiModelProperty("联系人姓名")
    private String contactName;

    /**
     * 银行信息
     */
    @ApiModelProperty("银行信息")
    private List<SupplierBankVo> banks;

    /**
     * 利润中心
     */
    @ApiModelProperty("利润中心")
    private String profitCenter;

    /**
     * 公司
     */
    @ApiModelProperty("公司")
    private String company;


}

