package com.biz.crm.mdm.business.table.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.feign.feign.ColumnConfigPersonalVoServiceFeign;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigPersonalVo;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年12月27日 16:32:00
 */
@Component
@Slf4j
public class ColumnConfigPersonalVoServiceFeignImpl implements FallbackFactory<ColumnConfigPersonalVoServiceFeign> {
  @Override
  public ColumnConfigPersonalVoServiceFeign create(Throwable throwable) {
    log.error("进入CustomerAddressVoServiceFeign熔断", throwable);
    return new ColumnConfigPersonalVoServiceFeign() {
      @Override
      public Result<List<ColumnConfigPersonalVo>> findByParentCodeAndFunctionCodeForExport(
          @RequestParam @ApiParam(name = "parentCode", value = "上级菜单", required = true) String parentCode,
          @RequestParam @ApiParam(name = "functionCode", value = "菜单") String functionCode,
          @RequestParam @ApiParam(name = "account", value = "账户") String account,
          @RequestParam @ApiParam(name = "tenantCode", value = "租户") String tenantCode) {
        throw new UnsupportedOperationException("查询MDM查询个性设置字段列表熔断");
      }

      @Override
      public Result<List<ColumnConfigPersonalVo>> findByParentCodeAndFunctionCode(
          @RequestParam @ApiParam(name = "parentCode", value = "上级菜单", required = true) String parentCode,
          @RequestParam @ApiParam(name = "functionCode", value = "菜单") String functionCode) {
        throw new UnsupportedOperationException("查询MDM查询个性设置字段列表熔断");
      }
    };
  }
}
