package com.biz.crm.mdm.business.table.feign.service;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.table.feign.feign.ColumnConfigPersonalVoServiceFeign;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalBatchDto;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigPersonalVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigPersonalVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe: ColumnConfigPersonalVoService Feign模块实现
 * @createTime 2022年12月27日 16:31:00
 */

@Service
public class ColumnConfigPersonalVoServiceImpl implements ColumnConfigPersonalVoService {
  @Autowired
  private ColumnConfigPersonalVoServiceFeign columnConfigPersonalVoServiceFeign;
  @Autowired
  private LoginUserService                   loginUserService;
  
  @Override
  public List<ColumnConfigPersonalVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    String tenantCode = TenantUtils.getTenantCode();
    AbstractCrmUserIdentity abstractLoginUser = loginUserService.getAbstractLoginUser();
    String account = abstractLoginUser.getAccount();
    Result<List<ColumnConfigPersonalVo>> result = this.columnConfigPersonalVoServiceFeign
        .findByParentCodeAndFunctionCodeForExport(parentCode, functionCode, account, tenantCode);
    return result.getResult();
  }
  
  @Override
  public void createByColumnConfigPersonalBatchDto(ColumnConfigPersonalBatchDto columnConfigPersonalBatchDto) {
    throw new UnsupportedOperationException("该实现未测试验证，不能直接通过feign远程调用，需要用户身份信息");
  }
  
  @Override
  public void deleteByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    throw new UnsupportedOperationException("该实现未测试验证，不能直接通过feign远程调用，需要用户身份信息");
  }
  
}
