package com.biz.crm.mdm.business.table.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalBatchDto;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigPersonalVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigPersonalVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author hefan
 */
@Api(tags = "页面引擎：ColumnConfigPersonalVo: 个性化配置")
@Slf4j
@RestController
@RequestMapping("/v1/table/columnConfigPersonal")
public class ColumnConfigPersonalVoController {

  @Autowired(required = false)
  private ColumnConfigPersonalVoService columnConfigPersonalVoService;

  /**
   * 老路径：/mdmColumnConfigPersonalController/findColumnConfigPersonalList
   * hefan:
   * 入参： parentCode functionCode 当前登陆人的positionCode
   * 返回：根据 个性化配置 过滤后的columnConfig
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  @ApiOperation(value = "查询个性设置字段列表")
  @GetMapping("/findByParentCodeAndFunctionCode")
  public Result<List<ColumnConfigPersonalVo>> findByParentCodeAndFunctionCode(@RequestParam @ApiParam(name = "parentCode", value = "上级菜单", required = true) String parentCode,
                                                                              @RequestParam @ApiParam(name = "functionCode", value = "菜单") String functionCode) {
    List<ColumnConfigPersonalVo> result = this.columnConfigPersonalVoService.findByParentCodeAndFunctionCode(parentCode, functionCode);
    return Result.ok(result);
  }

  /**
   * 老路径：/mdmColumnConfigPersonalController/saveColumnConfigPersonal
   * hefan: 保存个性化配置
   *
   * @param columnConfigPersonalBatchDto
   * @return
   */
  @ApiOperation(value = "保存个性设置")
  @PostMapping("")
  public Result createByColumnConfigPersonalBatchDto(@RequestBody ColumnConfigPersonalBatchDto columnConfigPersonalBatchDto) {
    this.columnConfigPersonalVoService.createByColumnConfigPersonalBatchDto(columnConfigPersonalBatchDto);
    return Result.ok();
  }

  /**
   * 老路径：/mdmColumnConfigPersonalController/deleteColumnConfigPersonal
   * hefan:
   * 根据 parentCode functionCode 当前登陆人的positionCode 删除 个性设置
   *
   * @return
   */
  @ApiOperation(value = "删除个性设置")
  @DeleteMapping("/deleteByParentCodeAndFunctionCode")
  public Result deleteByParentCodeAndFunctionCode(@RequestParam @ApiParam(name = "parentCode", value = "上级菜单", required = true) String parentCode,
                                                  @RequestParam @ApiParam(name = "functionCode", value = "菜单", required = true) String functionCode) {
    this.columnConfigPersonalVoService.deleteByParentCodeAndFunctionCode(parentCode, functionCode);
    return Result.ok("删除成功");
  }

}
