package com.biz.crm.mdm.business.table.local.deprecated.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.local.controller.ColumnConfigVoController;
import com.biz.crm.mdm.business.table.local.controller.TableConfigVoController;
import com.biz.crm.mdm.business.table.sdk.deprecated.dto.MdmTableConfigReqVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.vo.MdmColumnConfigRespVo;
import com.biz.crm.mdm.business.table.sdk.deprecated.vo.MdmTableConfigRespVo;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import com.biz.crm.mdm.business.table.sdk.vo.TableConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/**
 * 列表配置
 *
 * @author zxw
 * @date 2020-11-21 14:25:32
 */
@Slf4j
@RestController
@RequestMapping("/mdmtableconfig")
@Api(tags = "列表配置")
public class MdmTableConfigController {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private TableConfigVoController tableConfigVoController;
  /**
   * hefan:
   *  入参： parentCode functionCode
   *  返回对象内包含：
   *    角色权限内的按钮信息
   *    页面引擎主表【页面模板】的字段信息
   *    apiUrl
   *  返回的对象字段按照个性化字段配置排序、赋值可见性
   * @param mdmTableConfigReqVo
   * @return
   */
  @ApiOperation(value = "根据菜单编码和功能编码查询列表配置")
  @PostMapping("/query")
  public Result<MdmTableConfigRespVo> query(@RequestBody MdmTableConfigReqVo mdmTableConfigReqVo) {
    Result<TableConfigVo> result = tableConfigVoController.findByParentCodeAndFunctionCode(mdmTableConfigReqVo.getParentCode(), mdmTableConfigReqVo.getFunctionCode());
    MdmTableConfigRespVo mdmTableConfigRespVo = this.nebulaToolkitService.copyObjectByBlankList(result.getResult(), MdmTableConfigRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(mdmTableConfigRespVo);
  }

  @Autowired(required = false)
  private ColumnConfigVoController columnConfigVoController;

  /**
   * hefan: 根据parentCode、functionCode 查询 ColumnConfig ，并按照 formorder 排序
   *
   * @param mdmTableConfigReqVo
   * @return
   */
  @ApiOperation("根据菜单编码和功能编码查询表单配置")
  @PostMapping("/form/query")
  public Result<List<MdmColumnConfigRespVo>> formQuery(@RequestBody MdmTableConfigReqVo mdmTableConfigReqVo) {
    Result<List<ColumnConfigVo>> result = this.columnConfigVoController.findByParentCodeAndFunctionCodeOrderByFormorder(mdmTableConfigReqVo.getParentCode(), mdmTableConfigReqVo.getFunctionCode());
    List<MdmColumnConfigRespVo> mdmColumnConfigRespVos = (List<MdmColumnConfigRespVo>)this.nebulaToolkitService.copyCollectionByBlankList(result.getResult(), ColumnConfigVo.class, MdmColumnConfigRespVo.class, HashSet.class, LinkedList.class);
    return Result.ok(mdmColumnConfigRespVos);
  }

}
