package com.biz.crm.mdm.business.table.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;

import java.util.List;

/**
 * @author hefan
 */
public interface FunctionSubButtonMapper extends BaseMapper<MdmFunctionSubButtonEntity> {

  /**
   * 根据 parentCode，functionCode，visible 查询按钮信息
   *
   * @param parentCode
   * @param functionCode
   * @param visible
   * @return
   */
  List<MdmFunctionSubButtonEntity> findButtonByParentCodeAndFunctionCodeAndVisible(String parentCode, String functionCode, String visible);

  /**
   * 根据 parentCode，functionCode 查询按钮信息
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  List<MdmFunctionSubButtonEntity> findButtonByParentCodeAndFunctionCode(String parentCode, String functionCode);

  /**
   * 根据 id 查询按钮信息
   * @param id
   * @return
   */
  MdmFunctionSubButtonEntity findButtonById(String id);
}
