package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubButtonRepository;
import com.biz.crm.mdm.business.table.sdk.constant.PageEngineConstant;
import com.biz.crm.mdm.business.table.sdk.service.ButtonConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ButtonConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.service.ButtonVoService;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.icon.sdk.service.IconVoService;
import com.bizunited.nebula.icon.sdk.vo.IconVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author hefan
 */
@Service
public class ButtonConfigVoServiceImpl implements ButtonConfigVoService {

  @Autowired(required = false)
  private FunctionSubButtonRepository functionSubButtonRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private ButtonVoService buttonVoService;
  @Autowired(required = false)
  private IconVoService iconVoService;

  @Override
  public List<ButtonConfigVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    Validate.notBlank(parentCode, "菜单编码不能为空");
    Validate.notBlank(functionCode, "页面模板编码不能为空");
    List<MdmFunctionSubButtonEntity> functionSubButton = this.functionSubButtonRepository.findButtonByParentCodeAndFunctionCode(parentCode, functionCode);
    List<ButtonConfigVo> buttonConfigVos = (List<ButtonConfigVo>) this.nebulaToolkitService.copyCollectionByBlankList(functionSubButton, MdmFunctionSubButtonEntity.class, ButtonConfigVo.class, LinkedHashSet.class, LinkedList.class);
    List<String> iconCodeList = buttonConfigVos.stream().map(ButtonConfigVo::getIconCode).collect(Collectors.toList());
    //  图标信息
    List<IconVo> iconVos = this.iconVoService.findByIconCodeIn(iconCodeList);
    //  引擎按钮
    String code = StringUtils.join(parentCode, PageEngineConstant.JOINT_MARK, functionCode);
    List<ButtonVo> buttonVos = this.buttonVoService.findByCompetenceCode(code);
    Map<String, List<IconVo>> iconCodeMapIconVo = null;
    if (!CollectionUtils.isEmpty(iconVos)) {
      iconCodeMapIconVo = iconVos.stream().collect(Collectors.groupingBy(IconVo::getIconCode));
    }
    Map<String, List<ButtonVo>> codeMapButtonVo = null;
    if (!CollectionUtils.isEmpty(buttonVos)) {
      codeMapButtonVo = buttonVos.stream().collect(Collectors.groupingBy(ButtonVo::getCode));
    }
    for (ButtonConfigVo buttonConfigVo : buttonConfigVos) {
      if (CollectionUtils.isEmpty(codeMapButtonVo)) {
        // 页面模板侧按钮，与 总控侧按钮 脱离管控。直接阻断
        continue;
      }
      List<ButtonVo> buttonVoList = codeMapButtonVo.get(buttonConfigVo.getCode());
      if (CollectionUtils.isEmpty(buttonVoList)) {
        continue;
      }
      ButtonVo buttonVo = buttonVoList.get(0);
      buttonConfigVo.setPageEngineButtonId(buttonConfigVo.getId());
      buttonConfigVo.setButtonId(buttonVo.getId());
      if (CollectionUtils.isEmpty(iconCodeMapIconVo)) {
        continue;
      }
      List<IconVo> iconVoList = iconCodeMapIconVo.get(buttonConfigVo.getIconCode());
      if (CollectionUtils.isEmpty(iconVoList)) {
        continue;
      }
      IconVo iconVo = iconVoList.get(0);
      buttonConfigVo.setIconUrl(iconVo.getIconUrl());
      buttonConfigVo.setIconName(iconVo.getIconName());
      buttonConfigVo.setIconStyle(iconVo.getIconStyle());
      buttonConfigVo.setIconEffect(iconVo.getIconEffect());
    }
    return buttonConfigVos;
  }

  @Override
  public ButtonConfigVo findById(String id) {
    Validate.notBlank(id, "id不能为空");
    MdmFunctionSubButtonEntity entity = this.functionSubButtonRepository.findButtonById(id);
    ButtonConfigVo buttonConfigVo = this.nebulaToolkitService.copyObjectByBlankList(entity, ButtonConfigVo.class, LinkedHashSet.class, LinkedList.class);
    // 图标信息
    IconVo iconVo = this.iconVoService.findByIdOrIconCode(null, buttonConfigVo.getIconCode());
    if (Objects.nonNull(iconVo)) {
      buttonConfigVo.setIconUrl(iconVo.getIconUrl());
      buttonConfigVo.setIconName(iconVo.getIconName());
      buttonConfigVo.setIconStyle(iconVo.getIconStyle());
      buttonConfigVo.setIconEffect(iconVo.getIconEffect());
    }
    // 引擎按钮
    ButtonVo buttonVo = this.buttonVoService.findByCode(buttonConfigVo.getCode());
    if (Objects.nonNull(buttonVo)) {
      buttonConfigVo.setPageEngineButtonId(buttonConfigVo.getId());
      buttonConfigVo.setButtonId(buttonVo.getId());
    }
    return buttonConfigVo;
  }
}
