package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.table.local.entity.MdmColumnConfigEntity;
import com.biz.crm.mdm.business.table.local.entity.MdmColumnConfigPersonalEntity;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigPersonalRepository;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigRepository;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalBatchDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalDto;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigPersonalVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigPersonalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author hefan
 */
@Service
public class ColumnConfigPersonalVoServiceImpl implements ColumnConfigPersonalVoService {

  @Autowired(required = false)
  private ColumnConfigPersonalRepository columnConfigPersonalRepository;

  @Autowired(required = false)
  private ColumnConfigRepository columnConfigRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public List<ColumnConfigPersonalVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    // hefan：获取当前登录人的岗位
    String positionCode = this.getCurPositionCode();
    Validate.notBlank(parentCode, "缺失菜单编码");
    Validate.notBlank(functionCode, "缺失功能编码");
    // hefan：根据 parentCode functionCode 查询 ColumnConfig
    List<MdmColumnConfigEntity> columnList = this.columnConfigRepository.findByParentCodeAndFunctionCode(parentCode, functionCode);
    if (CollectionUtils.isEmpty(columnList)) {
      return Lists.newLinkedList();
    }
    // hefan: 转换ColumnConfig为 vo
    List<ColumnConfigPersonalVo> collect = columnList.stream().map(x -> {
      ColumnConfigPersonalVo personalRespVo = new ColumnConfigPersonalVo();
      personalRespVo.setTitle(x.getTitle());
      personalRespVo.setField(x.getField());
      personalRespVo.setVisible(BooleanUtils.isTrue(x.getVisible()));
      personalRespVo.setFormOrder(StringUtils.isNotEmpty(x.getFormorder()) ? x.getFormorder() : "100");
      return personalRespVo;
    }).collect(Collectors.toList());
    // hefan：根据 positionCode parentCode functionCode 查询 个性化配置
    List<MdmColumnConfigPersonalEntity> list = this.columnConfigPersonalRepository.findByPositionAndParentAndFunctionOrderByFormOrderAsc(positionCode, parentCode, functionCode);
    if (!CollectionUtils.isEmpty(list)) {
      // hefan: 根据 个性化配置 赋值 columnConfig
      Map<String, MdmColumnConfigPersonalEntity> filedMap = list.stream()
          .collect(Collectors.toMap(MdmColumnConfigPersonalEntity::getField, v -> v));
      for (ColumnConfigPersonalVo item : collect) {
        if (!filedMap.containsKey(item.getField())) {
          item.setFormOrder("100");
        } else {
          MdmColumnConfigPersonalEntity mdmColumnConfigPersonalEntity = filedMap.get(item.getField());
          item.setVisible(mdmColumnConfigPersonalEntity.getVisible());
          item.setFormOrder(mdmColumnConfigPersonalEntity.getFormOrder());
          item.setFunctionCode(mdmColumnConfigPersonalEntity.getFunctionCode());
          item.setParentCode(mdmColumnConfigPersonalEntity.getParentCode());
          item.setPositionCode(mdmColumnConfigPersonalEntity.getPositionCode());
          item.setId(mdmColumnConfigPersonalEntity.getId());
        }
      }
    }
    collect.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFormOrder()).map(Integer::valueOf).orElse(100)));
    return collect;
  }

  @Transactional
  @Override
  public void createByColumnConfigPersonalBatchDto(ColumnConfigPersonalBatchDto columnConfigPersonalBatchDto) {
    // 获取 当前登陆人的岗位code
    String positionCode = this.getCurPositionCode();
    String parentCode = columnConfigPersonalBatchDto.getParentCode();
    String functionCode = columnConfigPersonalBatchDto.getFunctionCode();
    Validate.notBlank(parentCode, "缺失菜单编码");
    Validate.notBlank(functionCode, "缺失功能编码");
    List<ColumnConfigPersonalDto> columnList = columnConfigPersonalBatchDto.getColumnList();
    Validate.notEmpty(columnList, "缺失字段配置");
    for (ColumnConfigPersonalDto item : columnList) {
      Validate.notBlank(item.getField(), "缺失属性");
      Validate.notNull(item.getVisible(), "缺失显示模式");
      Validate.notBlank(item.getFormOrder(), "缺失显示顺序");
      item.setFunctionCode(functionCode);
      item.setParentCode(parentCode);
      item.setPositionCode(positionCode);
    }
    //删除信息
    this.columnConfigPersonalRepository.deleteByParentCodeAndFunctionCodeAndPositionCode(parentCode, functionCode, positionCode);
    // 批量 保存
    List<MdmColumnConfigPersonalEntity> mdmColumnConfigPersonalEntities = (List<MdmColumnConfigPersonalEntity>) this.nebulaToolkitService.copyCollectionByBlankList(columnList, ColumnConfigPersonalDto.class, MdmColumnConfigPersonalEntity.class, HashSet.class, LinkedList.class);
    this.columnConfigPersonalRepository.saveBatch(mdmColumnConfigPersonalEntities);
    // fixme: 原逻辑：清除缓存
  }

  @Transactional
  @Override
  public void deleteByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    String positionCode = this.getCurPositionCode();
    Validate.notBlank(parentCode, "缺失菜单编码");
    Validate.notBlank(functionCode, "缺失功能编码");
    this.columnConfigPersonalRepository.deleteByPositionCodeAndParentCodeAndFunctionCode(positionCode, parentCode, functionCode);
    // fixme: 原逻辑：清除缓存
  }

  private String getCurPositionCode() {
    LoginUserDetails loginUserDetails = loginUserService.getLoginDetails(LoginUserDetails.class);
    return loginUserDetails.getPostCode();
  }


}
