package com.biz.crm.mdm.business.table.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.table.local.entity.MdmColumnConfigEntity;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigRepository;
import com.biz.crm.mdm.business.table.local.service.ColumnConfigPersonalService;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigBatchCreateDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPaginationDto;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author hefan
 */
@Service
public class ColumnConfigVoServiceImpl implements ColumnConfigVoService {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private ColumnConfigRepository columnConfigRepository;
  @Autowired(required = false)
  private ColumnConfigPersonalService columnConfigPersonalService;

  @Override
  public Page<ColumnConfigVo> findByCondition(Pageable pageable, ColumnConfigPaginationDto columnConfigPaginationDto) {
    if (Objects.isNull(columnConfigPaginationDto)) {
      return null;
    }
    return this.columnConfigRepository.findByCondition(pageable, columnConfigPaginationDto);
  }

  @Override
  public List<ColumnConfigVo> findByParentCodeAndFunctionCodeOrderByFormorder(String parentCode, String functionCode) {
    if (StringUtils.isEmpty(parentCode) || StringUtils.isEmpty(functionCode)) {
      return Lists.newLinkedList();
    }
    List<MdmColumnConfigEntity> list = this.columnConfigRepository.findByParentCodeAndFunctionCode(parentCode, functionCode);
    // hefan：根据formorder 排序。 为什么是100，我也不知道。
    int oneHundred = 100;
    if (!CollectionUtils.isEmpty(list)) {
      list = list.stream().sorted(Comparator.comparing(x -> Optional.ofNullable(x.getFormorder())
          .map(Integer::valueOf)
          .orElse(oneHundred))).collect(Collectors.toList());
    }
    List<ColumnConfigVo> columnConfigVos = (List<ColumnConfigVo>) this.nebulaToolkitService.copyCollectionByBlankList(list, MdmColumnConfigEntity.class, ColumnConfigVo.class, HashSet.class, LinkedList.class);
    return columnConfigVos;
  }

  @Override
  public ColumnConfigVo findByParentCodeAndFunctionCodeAndField(String parentCode, String functionCode, String field) {
    MdmColumnConfigEntity one = this.columnConfigRepository.findByParentCodeAndFunctionCodeAndField(parentCode, functionCode, field);
    ColumnConfigVo columnConfigVo = this.nebulaToolkitService.copyObjectByBlankList(one, ColumnConfigVo.class, HashSet.class, LinkedList.class);
    return columnConfigVo;
  }

  @Transactional
  @Override
  public void createByColumnConfigBatchCreateDto(ColumnConfigBatchCreateDto columnConfigBatchCreateDto) {
    this.createValidation(columnConfigBatchCreateDto);
    String parentCode = columnConfigBatchCreateDto.getParentCode();
    String functionCode = columnConfigBatchCreateDto.getFunctionCode();
    List<ColumnConfigDto> mdmColumnConfigVos = columnConfigBatchCreateDto.getMdmColumnConfigVos();
    // 根据 parentCode functionCode 删除
    this.columnConfigRepository.deleteByParentCodeAndFunctionCode(parentCode, functionCode);
    // 入参 转换 entity
    List<MdmColumnConfigEntity> mdmColumnConfigEntities = (List<MdmColumnConfigEntity>) this.nebulaToolkitService.copyCollectionByBlankList(mdmColumnConfigVos, ColumnConfigDto.class, MdmColumnConfigEntity.class, HashSet.class, LinkedList.class);
    for (MdmColumnConfigEntity entity : mdmColumnConfigEntities) {
      Validate.notBlank(entity.getField(), "字段名称不能为空");
      entity.setParentCode(parentCode);
      entity.setFunctionCode(functionCode);
      entity.setId(null);
    }
    // 批量保存
    this.columnConfigRepository.saveBatch(mdmColumnConfigEntities);
    // 根据 parentCode functionCode 删除 字段配置个性设置
    this.columnConfigPersonalService.deleteByParentCodeAndFunctionCode(parentCode, functionCode);
  }

  @Transactional
  @Override
  public void createByColumnConfigDto(ColumnConfigDto columnConfigDto) {
    this.createValidation(columnConfigDto);
    this.columnConfigRepository.deleteByParentCodeAndFunctionCodeAndField(columnConfigDto.getParentCode(), columnConfigDto.getFunctionCode(), columnConfigDto.getField());
    MdmColumnConfigEntity entity = this.nebulaToolkitService.copyObjectByBlankList(columnConfigDto, MdmColumnConfigEntity.class, HashSet.class, LinkedList.class);
    this.columnConfigRepository.save(entity);
    this.columnConfigPersonalService.deleteByParentCodeAndFunctionCode(columnConfigDto.getParentCode(), columnConfigDto.getFunctionCode());
  }

  @Transactional
  @Override
  public void updateByColumnConfigDto(ColumnConfigDto columnConfigDto) {
    this.updateValidation(columnConfigDto);
    MdmColumnConfigEntity entity = this.nebulaToolkitService.copyObjectByBlankList(columnConfigDto, MdmColumnConfigEntity.class, HashSet.class, LinkedList.class);
    this.columnConfigRepository.updateById(entity);
    this.columnConfigPersonalService.deleteByParentCodeAndFunctionCode(columnConfigDto.getParentCode(), columnConfigDto.getFunctionCode());
  }

  @Transactional
  @Override
  public void deleteByIdIn(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "id集合不能为空");
    List<MdmColumnConfigEntity> list = this.columnConfigRepository.findByIdIn(ids);
    Validate.isTrue(!CollectionUtils.isEmpty(list), "数据库中没有要删除的信息");
    // fixme: 原逻辑：拿出一条信息，并用取得的信息去删除个性化字段配置。hefan：感觉像bug，但又不能改
    MdmColumnConfigEntity mdmColumnConfigEntity = list.get(0);
    String parentCode = mdmColumnConfigEntity.getParentCode();
    String functionCode = mdmColumnConfigEntity.getFunctionCode();
    if (!StringUtils.isEmpty(parentCode) && !StringUtils.isEmpty(functionCode)) {
      columnConfigPersonalService.deleteByParentCodeAndFunctionCode(parentCode, functionCode);
    }
    this.columnConfigRepository.removeByIds(ids);
  }

  @Transactional
  @Override
  public void enableByIdIn(List<String> ids) {
    //设置状态为启用
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "id集合不能为空");
    String enableStatusCode = EnableStatusEnum.ENABLE.getCode();
    this.columnConfigRepository.updateEnableStatusByIdIn(ids, enableStatusCode);
  }

  @Override
  public Collection<ColumnConfigVo> findByParentCode(String parentCode) {
    List<MdmColumnConfigEntity> list = columnConfigRepository.findByParentCode(parentCode);
    Collection<ColumnConfigVo> columnConfigVos = nebulaToolkitService.copyCollectionByBlankList(list, MdmColumnConfigEntity.class, ColumnConfigVo.class, HashSet.class, LinkedList.class);
    return columnConfigVos;
  }

  /**
   * 修改时校验
   *
   * @param columnConfigDto
   */
  private void updateValidation(ColumnConfigDto columnConfigDto) {
    Validate.notNull(columnConfigDto, "入参不能为空");
    Validate.notBlank(columnConfigDto.getParentCode(), "菜单编码不能为空");
    Validate.notBlank(columnConfigDto.getFunctionCode(), "功能编码不能为空");
    Validate.notBlank(columnConfigDto.getField(), "字段名称不能为空");
    this.validSearchAndExport(Collections.singletonList(columnConfigDto));
    String id = columnConfigDto.getId();
    Validate.notBlank(id, "主键不能为空");
    MdmColumnConfigEntity entityDB = this.columnConfigRepository.getById(id);
    Validate.notNull(entityDB, "字段不存在");
  }

  /**
   * 创建时校验
   *
   * @param columnConfigDto
   */
  private void createValidation(ColumnConfigDto columnConfigDto) {
    Validate.notNull(columnConfigDto, "入参不能为空");
    Validate.notBlank(columnConfigDto.getParentCode(), "菜单编码不能为空");
    Validate.notBlank(columnConfigDto.getFunctionCode(), "功能编码不能为空");
    Validate.notBlank(columnConfigDto.getField(), "字段名称不能为空");
    columnConfigDto.setId(null);
    this.validSearchAndExport(Collections.singletonList(columnConfigDto));
  }

  /**
   * 创建时校验
   *
   * @param columnConfigBatchCreateDto
   */
  private void createValidation(ColumnConfigBatchCreateDto columnConfigBatchCreateDto) {
    Validate.notNull(columnConfigBatchCreateDto, "入参不能为空");
    String parentCode = columnConfigBatchCreateDto.getParentCode();
    Validate.notBlank(parentCode, "菜单编码不能为空");
    String functionCode = columnConfigBatchCreateDto.getFunctionCode();
    Validate.notBlank(functionCode, "功能编码不能为空");
    List<ColumnConfigDto> mdmColumnConfigVos = columnConfigBatchCreateDto.getMdmColumnConfigVos();
    Validate.isTrue(!CollectionUtils.isEmpty(mdmColumnConfigVos), "新增列表不能为空");
    Set<String> set = new HashSet<>(mdmColumnConfigVos.size());
    for (ColumnConfigDto mdmColumnConfigVo : mdmColumnConfigVos) {
      Validate.isTrue(set.add(mdmColumnConfigVo.getField()), "存在相同的字段:" + mdmColumnConfigVo.getField());
    }
    // 控件类型校验
    this.validSearchAndExport(mdmColumnConfigVos);
  }

  /**
   * 校验：
   * 允许查询的字段,需要配置控件类型
   * 需要导出的字段，标题不能为空
   *
   * @param list
   */
  private void validSearchAndExport(List<ColumnConfigDto> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    for (ColumnConfigDto mdmColumnConfigReqVo : list) {
      if (mdmColumnConfigReqVo != null && BooleanEnum.TRUE.name().equalsIgnoreCase(mdmColumnConfigReqVo.getSearch())) {
        Validate.notBlank(mdmColumnConfigReqVo.getType(), "字段(" + mdmColumnConfigReqVo.getTitle() + ")允许查询需要配置控件类型");
      }
      if (StringUtils.equals(BooleanEnum.TRUE.getNumStr(), mdmColumnConfigReqVo.getColumnExport())) {
        Validate.notBlank(mdmColumnConfigReqVo.getTitle(), "需要导出的字段:" + mdmColumnConfigReqVo.getField() + ",标题不能为空");
      }
    }

  }
}
