package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubButtonRepository;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubRepository;
import com.biz.crm.mdm.business.table.local.service.FunctionSubButtonService;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubButtonDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.service.CompetenceButtonMappingService;
import jodd.util.ArraysUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/**
 * @author hefan
 */
@Service
public class FunctionSubButtonServiceImpl implements FunctionSubButtonService {

  @Autowired(required = false)
  private FunctionSubButtonRepository functionSubButtonRepository;
  @Autowired(required = false)
  private FunctionSubRepository functionSubRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private CompetenceButtonMappingService competenceButtonMappingService;

  @Transactional
  @Override
  public MdmFunctionSubButtonEntity create(FunctionSubButtonDto functionSubButtonDto) {
    /**
     * 默认值填充
     * 校验数据
     * 保存数据
     */
    MdmFunctionSubButtonEntity mdmFunctionSubButtonEntity = this.nebulaToolkitService.copyObjectByBlankList(functionSubButtonDto, MdmFunctionSubButtonEntity.class, HashSet.class, LinkedList.class);
    return this.create(mdmFunctionSubButtonEntity);
  }

  @Transactional
  @Override
  public MdmFunctionSubButtonEntity create(MdmFunctionSubButtonEntity entity) {
    entity.setTenantCode(TenantUtils.getTenantCode());
    this.createValidation(entity);
    this.functionSubButtonRepository.save(entity);
    // 页面模板（功能） 与 按钮绑定了。 总控那边也要绑定
    String code = entity.getCode();
    MdmFunctionSubEntity functionSubEntity = functionSubRepository.findOneByParentCodeAndFunctionCode(entity.getParentCode(), entity.getFunctionCode());
    String competenceCode = functionSubEntity.getCode();
    String[] array = ArraysUtil.array(competenceCode);
    this.competenceButtonMappingService.bindButton(code, array);
    return entity;
  }

  @Transactional
  @Override
  public MdmFunctionSubButtonEntity update(MdmFunctionSubButtonEntity entity) {
    entity.setTenantCode(TenantUtils.getTenantCode());
    this.updateValidation(entity);
    this.functionSubButtonRepository.updateById(entity);
    return entity;
  }

  private void updateValidation(MdmFunctionSubButtonEntity mdmFunctionSubButtonEntity) {
    Validate.notNull(mdmFunctionSubButtonEntity, "入参信息不能为空");
    Validate.notBlank(mdmFunctionSubButtonEntity.getId(), "业务主键不能为空");
    Validate.notBlank(mdmFunctionSubButtonEntity.getParentCode(), "菜单编码不能为空");
    Validate.notBlank(mdmFunctionSubButtonEntity.getFunctionCode(), "功能编码不能为空");
    Validate.notBlank(mdmFunctionSubButtonEntity.getButtonCode(), "前端按钮组件编码不能为空");
    Validate.notBlank(mdmFunctionSubButtonEntity.getCode(), "按钮编码不能为空");
  }

  @Transactional
  @Override
  public void deleteByIdIn(List<String> ids) {
    /**
     * 查询数据库内的数据
     * 清除缓存内数据
     * 删除数据库内的数据
     */
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "id集合不能为空");
    List<MdmFunctionSubButtonEntity> list = this.functionSubButtonRepository.findByIdIn(ids);
    Validate.isTrue(!CollectionUtils.isEmpty(list), "没有数据需要删除");
    // fixme 原逻辑为什么要只获取一条数据；要清除缓存，怎么就只获取一条数据
    // fixme 原逻辑：清除页面配置缓存；实际：从redis中删除数据；当前处理：假装没有看见
    this.functionSubButtonRepository.removeByIds(ids);
  }

  @Override
  public MdmFunctionSubButtonEntity findByCode(String code) {
    if (StringUtils.isBlank(code)) {
      return null;
    }
    return this.functionSubButtonRepository.findByCode(code, TenantUtils.getTenantCode());
  }

  @Override
  public MdmFunctionSubButtonEntity findById(String pageEngineButtonId) {
    if (StringUtils.isBlank(pageEngineButtonId)) {
      return null;
    }
    return this.functionSubButtonRepository.getById(pageEngineButtonId);
  }

  /**
   * 保存时数据校验
   * @param mdmFunctionSubButtonEntity
   */
  private void createValidation(MdmFunctionSubButtonEntity mdmFunctionSubButtonEntity) {
    Validate.notNull(mdmFunctionSubButtonEntity, "入参信息不能为空");
    Validate.notBlank(mdmFunctionSubButtonEntity.getParentCode(), "菜单编码不能为空");
    Validate.notBlank(mdmFunctionSubButtonEntity.getFunctionCode(), "功能编码不能为空");
    Validate.notBlank(mdmFunctionSubButtonEntity.getButtonCode(), "前端按钮组件编码不能为空");
    Validate.notBlank(mdmFunctionSubButtonEntity.getCode(), "按钮编码不能为空");
    // fixme：去查询 mdm_button ; 校验button数据是否存在，按钮启用状态；
    // fixme: 去查询 mdm_function_sub ; 校验功能列表是否存在；
    // 移除，根据 parentCode,functionCode,buttonCode;
    this.functionSubButtonRepository.deleteByParentCodeAndFunctionCodeAndButtonCode(mdmFunctionSubButtonEntity);
    // fixme 原逻辑：清除页面配置缓存；实际：从redis中删除数据；当前处理：假装没有看见

  }
}
