package com.biz.crm.mdm.business.table.local.service.register;

import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubButtonRepository;
import com.biz.crm.mdm.business.table.sdk.constant.PageEngineConstant;
import com.biz.crm.mdm.business.table.sdk.vo.PageEngineButtonVo;
import com.biz.crm.mdm.business.table.sdk.vo.PageEngineCompetenceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.register.CompetenceRegister;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.competence.sdk.vo.CompetenceVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * 页面引擎 面向 按钮、功能的注册信息；
 * <p>
 * 功能：
 * URI指向的目标，都可以视为一种功能；
 * 即，拥有URI属性的抽象，都可以视为功能。
 *
 * @author hefan
 */
@Component
public class PageEngineCompetenceRegister implements CompetenceRegister<PageEngineCompetenceVo, PageEngineButtonVo> {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private FunctionSubButtonRepository functionSubButtonRepository;

  @Override
  public String getType() {
    return PageEngineConstant.PAGE_ENGINE;
  }

  @Override
  public String getComment() {
    return "页面引擎";
  }

  @Override
  public Class<PageEngineCompetenceVo> getCompetenceClass() {
    return PageEngineCompetenceVo.class;
  }

  @Override
  public PageEngineCompetenceVo cloneCompetence(CompetenceVo sourceCompetence) {
    PageEngineCompetenceVo sourceDefaultCompetence = (PageEngineCompetenceVo)sourceCompetence;
    // 只做自身的copy，不做任何关联信息（下级菜单/功能、关联按钮）的copy
    PageEngineCompetenceVo copyDefaultCompetence = this.nebulaToolkitService.copyObjectByWhiteList(sourceDefaultCompetence, PageEngineCompetenceVo.class, LinkedHashSet.class, ArrayList.class);
    // 然后是可能的按钮信息
    List<ButtonVo> buttonVos = sourceDefaultCompetence.getButtons();
    List<ButtonVo> copyButtons = Lists.newArrayList();
    if(!CollectionUtils.isEmpty(buttonVos)) {
      for (ButtonVo buttonVo : buttonVos) {
        copyButtons.add(this.nebulaToolkitService.copyObjectByWhiteList(buttonVo, buttonVo.getClass(), LinkedHashSet.class, ArrayList.class));
      }
      copyDefaultCompetence.setButtons(copyButtons);
    }
    return copyDefaultCompetence;
  }

  @Override
  public PageEngineButtonVo cloneButton(ButtonVo sourceButton) {
    PageEngineButtonVo sourceDefaultButton = (PageEngineButtonVo)sourceButton;
    // 只做自身的copy
    PageEngineButtonVo copyDefaultButton = this.nebulaToolkitService.copyObjectByBlankList(sourceDefaultButton, PageEngineButtonVo.class, LinkedHashSet.class, ArrayList.class);
    return copyDefaultButton;
  }

  @Override
  public Class<PageEngineButtonVo> getButtonClass() {
    return PageEngineButtonVo.class;
  }

  @Override
  public Set<PageEngineButtonVo> onRequestButtonVos(List<String> codes) {
    List<MdmFunctionSubButtonEntity> buttonList = this.functionSubButtonRepository.findByCodeIn(codes, TenantUtils.getTenantCode());
    if (CollectionUtils.isEmpty(buttonList)) {
      return Sets.newHashSet();
    }
    Set<PageEngineButtonVo> set = Sets.newHashSet();
    for (MdmFunctionSubButtonEntity entity : buttonList) {
      PageEngineButtonVo buttonVo = this.nebulaToolkitService.copyObjectByBlankList(entity, PageEngineButtonVo.class, HashSet.class, LinkedList.class);
      buttonVo.setType(entity.getButtonType());
      buttonVo.setName(entity.getButtonName());
      buttonVo.setButtonDesc(entity.getRemark());
      buttonVo.setIcon(entity.getIconCode());
      buttonVo.setCode(entity.getCode());
      set.add(buttonVo);
    }
    return set;
  }

  @Override
  public Set<PageEngineCompetenceVo> onRequestCompetenceVos(List<String> list) {

    return null;
  }

  @Override
  public boolean matchedResources(CompetenceVo competence, String resource, String method, boolean like, String tenantCode) {
    /**
     * fixme：
     * 判断请求路径在不在页面引擎管理中
     */
    PageEngineCompetenceVo defaultCompetenceVo = (PageEngineCompetenceVo)competence;
    String targetResource = defaultCompetenceVo.getApiUrl();
    Integer targetStatus = defaultCompetenceVo.getTstatus();
    if(StringUtils.isAnyBlank(targetResource) || targetStatus == null) {
      return false;
    }
    // 如果条件成立那么使用精确匹配，否则就是模糊匹配
    if(!like && StringUtils.equals(resource, targetResource)) {
      return true;
    } else if(like && StringUtils.indexOf(resource, targetResource) != -1) {
      return true;
    }
    return false;
  }

  /**
   *
   * @param competence
   * @param requestMappingInfo
   * @param tenantCode
   * @param request
   * @return
   */
  @Override
  public boolean matchedResources(CompetenceVo competence, RequestMappingInfo requestMappingInfo, String tenantCode, HttpServletRequest request) {
    /**
     * 页面引擎侧的判断逻辑：
     *   fixme：
     *  请求路径是否存在页面引擎中
     *
     */
    PageEngineCompetenceVo defaultCompetenceVo = (PageEngineCompetenceVo)competence;
    String matchedFix = tenantCode + "|";
    // 取得当前功能和角色的绑定关系(注意这里每一条信息都是tenantCode|roleCode)，且使用“|”进行了分割
    Set<String> tenantAndRoleCodes = competence.getRoleCodes();
    if(CollectionUtils.isEmpty(tenantAndRoleCodes)) {
      return false;
    }
    // 将角色添加到返回值中，证明当前系统中已设定当前角色可以访该功能
    // 每一条记录都是由tenantCode|roleCode构成
    for (String tenantAndRoleCode: tenantAndRoleCodes) {
      if(StringUtils.indexOf(tenantAndRoleCode, matchedFix) != 0) {
        return true;
      }
    }
    return false;
  }
}
