/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubButtonRepository;
import com.biz.crm.mdm.business.table.sdk.service.ButtonConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ButtonConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.service.ButtonVoService;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.bizunited.nebula.icon.sdk.service.IconVoService;
import com.bizunited.nebula.icon.sdk.vo.IconVo;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ButtonConfigVoServiceImpl
implements ButtonConfigVoService {
    @Autowired(required=false)
    private FunctionSubButtonRepository functionSubButtonRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ButtonVoService buttonVoService;
    @Autowired(required=false)
    private IconVoService iconVoService;

    public List<ButtonConfigVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)functionCode, (String)"\u9875\u9762\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<MdmFunctionSubButtonEntity> functionSubButton = this.functionSubButtonRepository.findButtonByParentCodeAndFunctionCode(parentCode, functionCode);
        List buttonConfigVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(functionSubButton, MdmFunctionSubButtonEntity.class, ButtonConfigVo.class, LinkedHashSet.class, LinkedList.class, new String[0]);
        List iconCodeList = buttonConfigVos.stream().map(ButtonConfigVo::getIconCode).collect(Collectors.toList());
        List iconVos = this.iconVoService.findByIconCodeIn(iconCodeList);
        String code = StringUtils.join((Object[])new String[]{parentCode, "@", functionCode});
        List buttonVos = this.buttonVoService.findByCompetenceCode(code);
        Map<String, List<IconVo>> iconCodeMapIconVo = null;
        if (!CollectionUtils.isEmpty((Collection)iconVos)) {
            iconCodeMapIconVo = iconVos.stream().collect(Collectors.groupingBy(IconVo::getIconCode));
        }
        Map<String, List<ButtonVo>> codeMapButtonVo = null;
        if (!CollectionUtils.isEmpty((Collection)buttonVos)) {
            codeMapButtonVo = buttonVos.stream().collect(Collectors.groupingBy(ButtonVo::getCode));
        }
        for (ButtonConfigVo buttonConfigVo : buttonConfigVos) {
            List<IconVo> iconVoList;
            List<ButtonVo> buttonVoList;
            if (CollectionUtils.isEmpty(codeMapButtonVo) || CollectionUtils.isEmpty(buttonVoList = codeMapButtonVo.get(buttonConfigVo.getCode()))) continue;
            ButtonVo buttonVo = buttonVoList.get(0);
            buttonConfigVo.setPageEngineButtonId(buttonConfigVo.getId());
            buttonConfigVo.setButtonId(buttonVo.getId());
            if (CollectionUtils.isEmpty(iconCodeMapIconVo) || CollectionUtils.isEmpty(iconVoList = iconCodeMapIconVo.get(buttonConfigVo.getIconCode()))) continue;
            IconVo iconVo = iconVoList.get(0);
            buttonConfigVo.setIconUrl(iconVo.getIconUrl());
            buttonConfigVo.setIconName(iconVo.getIconName());
            buttonConfigVo.setIconStyle(iconVo.getIconStyle());
            buttonConfigVo.setIconEffect(iconVo.getIconEffect());
        }
        return buttonConfigVos;
    }

    public ButtonConfigVo findById(String id) {
        ButtonVo buttonVo;
        Validate.notBlank((CharSequence)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MdmFunctionSubButtonEntity entity = this.functionSubButtonRepository.findButtonById(id);
        ButtonConfigVo buttonConfigVo = (ButtonConfigVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, ButtonConfigVo.class, LinkedHashSet.class, LinkedList.class, new String[0]);
        IconVo iconVo = this.iconVoService.findByIdOrIconCode(null, buttonConfigVo.getIconCode());
        if (Objects.nonNull(iconVo)) {
            buttonConfigVo.setIconUrl(iconVo.getIconUrl());
            buttonConfigVo.setIconName(iconVo.getIconName());
            buttonConfigVo.setIconStyle(iconVo.getIconStyle());
            buttonConfigVo.setIconEffect(iconVo.getIconEffect());
        }
        if (Objects.nonNull(buttonVo = this.buttonVoService.findByCode(buttonConfigVo.getCode()))) {
            buttonConfigVo.setPageEngineButtonId(buttonConfigVo.getId());
            buttonConfigVo.setButtonId(buttonVo.getId());
        }
        return buttonConfigVo;
    }
}

