/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.table.local.entity.MdmColumnConfigEntity;
import com.biz.crm.mdm.business.table.local.entity.MdmColumnConfigPersonalEntity;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigPersonalRepository;
import com.biz.crm.mdm.business.table.local.repository.ColumnConfigRepository;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalBatchDto;
import com.biz.crm.mdm.business.table.sdk.dto.ColumnConfigPersonalDto;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigPersonalVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigPersonalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ColumnConfigPersonalVoServiceImpl
implements ColumnConfigPersonalVoService {
    @Autowired(required=false)
    private ColumnConfigPersonalRepository columnConfigPersonalRepository;
    @Autowired(required=false)
    private ColumnConfigRepository columnConfigRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public List<ColumnConfigPersonalVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
        String positionCode = this.getCurPositionCode();
        Validate.notBlank((CharSequence)parentCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)functionCode, (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801", (Object[])new Object[0]);
        List<MdmColumnConfigEntity> columnList = this.columnConfigRepository.findByParentCodeAndFunctionCode(parentCode, functionCode);
        if (CollectionUtils.isEmpty(columnList)) {
            return Lists.newLinkedList();
        }
        List<ColumnConfigPersonalVo> collect = columnList.stream().map(x -> {
            ColumnConfigPersonalVo personalRespVo = new ColumnConfigPersonalVo();
            personalRespVo.setTitle(x.getTitle());
            personalRespVo.setField(x.getField());
            personalRespVo.setVisible(Boolean.valueOf(BooleanUtils.isTrue((Boolean)x.getVisible())));
            personalRespVo.setFormOrder(StringUtils.isNotEmpty((CharSequence)x.getFormorder()) ? x.getFormorder() : "100");
            return personalRespVo;
        }).collect(Collectors.toList());
        List<MdmColumnConfigPersonalEntity> list = this.columnConfigPersonalRepository.findByPositionAndParentAndFunctionOrderByFormOrderAsc(positionCode, parentCode, functionCode);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, MdmColumnConfigPersonalEntity> filedMap = list.stream().collect(Collectors.toMap(MdmColumnConfigPersonalEntity::getField, v -> v));
            for (ColumnConfigPersonalVo item : collect) {
                if (!filedMap.containsKey(item.getField())) {
                    item.setFormOrder("100");
                    continue;
                }
                MdmColumnConfigPersonalEntity mdmColumnConfigPersonalEntity = filedMap.get(item.getField());
                item.setVisible(mdmColumnConfigPersonalEntity.getVisible());
                item.setFormOrder(mdmColumnConfigPersonalEntity.getFormOrder());
                item.setFunctionCode(mdmColumnConfigPersonalEntity.getFunctionCode());
                item.setParentCode(mdmColumnConfigPersonalEntity.getParentCode());
                item.setPositionCode(mdmColumnConfigPersonalEntity.getPositionCode());
                item.setId(mdmColumnConfigPersonalEntity.getId());
            }
        }
        collect.sort(Comparator.comparing(x -> Optional.ofNullable(x.getFormOrder()).map(Integer::valueOf).orElse(100)));
        return collect;
    }

    @Transactional
    public void createByColumnConfigPersonalBatchDto(ColumnConfigPersonalBatchDto columnConfigPersonalBatchDto) {
        String positionCode = this.getCurPositionCode();
        String parentCode = columnConfigPersonalBatchDto.getParentCode();
        String functionCode = columnConfigPersonalBatchDto.getFunctionCode();
        Validate.notBlank((CharSequence)parentCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)functionCode, (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801", (Object[])new Object[0]);
        List columnList = columnConfigPersonalBatchDto.getColumnList();
        Validate.notEmpty((Collection)columnList, (String)"\u7f3a\u5931\u5b57\u6bb5\u914d\u7f6e", (Object[])new Object[0]);
        for (ColumnConfigPersonalDto item : columnList) {
            Validate.notBlank((CharSequence)item.getField(), (String)"\u7f3a\u5931\u5c5e\u6027", (Object[])new Object[0]);
            Validate.notNull((Object)item.getVisible(), (String)"\u7f3a\u5931\u663e\u793a\u6a21\u5f0f", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getFormOrder(), (String)"\u7f3a\u5931\u663e\u793a\u987a\u5e8f", (Object[])new Object[0]);
            item.setFunctionCode(functionCode);
            item.setParentCode(parentCode);
            item.setPositionCode(positionCode);
        }
        this.columnConfigPersonalRepository.deleteByParentCodeAndFunctionCodeAndPositionCode(parentCode, functionCode, positionCode);
        List mdmColumnConfigPersonalEntities = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)columnList, ColumnConfigPersonalDto.class, MdmColumnConfigPersonalEntity.class, HashSet.class, LinkedList.class, new String[0]);
        this.columnConfigPersonalRepository.saveBatch(mdmColumnConfigPersonalEntities);
    }

    @Transactional
    public void deleteByParentCodeAndFunctionCode(String parentCode, String functionCode) {
        String positionCode = this.getCurPositionCode();
        Validate.notBlank((CharSequence)parentCode, (String)"\u7f3a\u5931\u83dc\u5355\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)functionCode, (String)"\u7f3a\u5931\u529f\u80fd\u7f16\u7801", (Object[])new Object[0]);
        this.columnConfigPersonalRepository.deleteByPositionCodeAndParentCodeAndFunctionCode(positionCode, parentCode, functionCode);
    }

    private String getCurPositionCode() {
        LoginUserDetails loginUserDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        return loginUserDetails.getPostCode();
    }
}

