package com.biz.crm.mdm.business.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * 功能列表与按钮关联表实体类
 *    fixme: 关联表命名规范
 * @author zxw
 * @date 2020-12-05 12:56:52
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmFunctionSubButtonEntity", description = "功能列表与按钮关联表实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`mdm_function_sub_button`", comment = "功能列表与按钮关联表实体类")
@TableName("mdm_function_sub_button")
@Table(name = "`mdm_function_sub_button`", indexes = {
    @Index(name = "idx_parent_code_function_code", columnList = "parent_code,function_code"),
    @Index(name = "uk_code", columnList = "code", unique = true)
})
public class MdmFunctionSubButtonEntity extends TenantFlagOpEntity {

  /**
   * 按钮编码
   */
  @ApiModelProperty("按钮编码")
  @Column(name = "code", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 按钮编码 '")
  private String code;

  /**
   * 前端的按钮组件编码
   */
  @ApiModelProperty("前端的按钮组件编码")
  @Column(name = "button_code", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 前端的按钮组件编码 '")
  private String buttonCode;

  /**
   * 按钮名称
   */
  @ApiModelProperty("按钮名称")
  @Column(name = "button_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 按钮名称 '")
  private String buttonName;

  @ApiModelProperty("按钮类型:0表头按钮，1行按钮")
  @Column(name = "button_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 按钮类型:0表头按钮，1行按钮 '")
  private String buttonType;

  @ApiModelProperty("图标编码")
  @Column(name = "icon_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 图标编码 '")
  private String iconCode;

  /**
   * 询问语
   */
  @ApiModelProperty("询问语")
  @Column(name = "ask", nullable = true, length = 200, columnDefinition = "VARCHAR(200) COMMENT ' 询问语 '")
  private String ask;

  /**
   * 功能查询地址
   */
  @ApiModelProperty("功能查询地址")
  @Column(name = "query_url", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 功能查询地址 '")
  private String queryUrl;

  /**
   * url
   */
  @ApiModelProperty("url")
  @Column(name = "api_url", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' url '")
  private String apiUrl;

  /**
   * api url 请求映射
   */
  @ApiModelProperty("apiUrlRequestMapping")
  @Column(name = "api_url_request_mapping", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT ' api url 请求映射方式 '")
  private String apiUrlRequestMapping;

  /**
   * 按钮操作类型
   */
  @ApiModelProperty("按钮操作类型")
  @Column(name = "button_operation_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 按钮操作类型 '")
  private String buttonOperationType;

  /**
   * 上级菜单编码
   */
  @ApiModelProperty("上级菜单编码")
  @Column(name = "parent_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 上级菜单编码 '")
  private String parentCode;

  /**
   * 功能列表编码
   */
  @ApiModelProperty("功能列表编码")
  @Column(name = "function_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 功能列表编码 '")
  private String functionCode;

  /**
   * 排序
   */
  @ApiModelProperty("排序")
  @Column(name = "button_order", nullable = true, columnDefinition = "int(11) COMMENT ' 排序 '")
  private Integer buttonOrder;

  /**
   * 功能编码
   */
  @ApiModelProperty("功能编码")
  @Column(name = "do_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 功能编码 '")
  private String doCode;

  /**
   * 显示模式：true显示，false隐藏
   */
  @ApiModelProperty("显示模式：true显示，false隐藏")
  @Column(name = "visible", nullable = true, length = 1, columnDefinition = "bit(1) COMMENT ' 显示模式：true显示，false隐藏 '")
  private Boolean visible;

  /**
   * 导入按钮编码
   */
  @ApiModelProperty("导入按钮编码")
  @Column(name = "config_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 导入按钮编码 '")
  private String configCode;

  /**
   * 页面模板
   */
  @ApiModelProperty("页面模板")
  @TableField(exist = false)
  @Transient
  private MdmFunctionSubEntity functionSubEntity;

  @ApiModelProperty("按钮方法")
  @Column(name = "button_method", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 按钮方法 '")
  private String buttonMethod;

}
