package com.biz.crm.mdm.business.table.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.local.mapper.FunctionSubMapper;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubDto;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubPaginationDto;
import com.biz.crm.mdm.business.table.sdk.vo.FunctionSubVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author hefan
 */
@Component
public class FunctionSubRepository extends ServiceImpl<FunctionSubMapper, MdmFunctionSubEntity> {

  @Autowired(required = false)
  private FunctionSubMapper functionSubMapper;

  /**
   * 分页 动态条件 查询
   *
   * @param pageable
   * @param functionSubPaginationDto
   * @return
   */
  public Page<FunctionSubVo> findByCondition(Pageable pageable, FunctionSubPaginationDto functionSubPaginationDto) {
    Page<FunctionSubVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return functionSubMapper.findByConditions(page, functionSubPaginationDto);
  }

  /**
   * 根据 上级菜单编码  下级菜单编码 查询 权限对象
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  public MdmFunctionSubEntity findPermissionObjByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    MdmFunctionSubEntity mdmFunctionSubEntity = this.lambdaQuery()
        .eq(MdmFunctionSubEntity::getParentCode, parentCode)
        .eq(MdmFunctionSubEntity::getFunctionCode, functionCode)
        .select(MdmFunctionSubEntity::getPermissionObj)
        .one();
    return mdmFunctionSubEntity;
  }

  /**
   * 根据 上级菜单编码  下级菜单编码 统计
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  public Integer countByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    Integer count = this.lambdaQuery()
        .eq(MdmFunctionSubEntity::getParentCode, parentCode)
        .eq(MdmFunctionSubEntity::getFunctionCode, functionCode)
        .count();
    return count;
  }

  /**
   * 根据 上级菜单编码  下级菜单编码 修改 权限
   *
   * @param parentCode
   * @param functionCode
   * @param permissionObjCodes
   */
  public void updatePermissionObjByParentCodeAndFunctionCode(String parentCode, String functionCode, String permissionObjCodes) {
    this.lambdaUpdate()
        .eq(MdmFunctionSubEntity::getParentCode, parentCode)
        .eq(MdmFunctionSubEntity::getFunctionCode, functionCode)
        .set(MdmFunctionSubEntity::getPermissionObj, permissionObjCodes)
        .update();
  }

  /**
   * 动态查询 function_sub
   *
   * @param functionSubDto
   * @return
   */
  public List<FunctionSubVo> findByFunctionSubDto(FunctionSubDto functionSubDto) {
    return this.functionSubMapper.findByFunctionSubDto(functionSubDto);
  }

  /**
   * 根据 ParentCode FunctionCode 查询 一条functionSub数据
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  public MdmFunctionSubEntity findOneByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    MdmFunctionSubEntity one = this.lambdaQuery()
        .eq(MdmFunctionSubEntity::getParentCode, parentCode)
        .eq(MdmFunctionSubEntity::getFunctionCode, functionCode)
        .one();
    return one;
  }

  /**
   * 根据ID查询
   *
   * @param id
   * @return
   */
  public MdmFunctionSubEntity findById(String id) {
    MdmFunctionSubEntity one = this.lambdaQuery()
        .eq(MdmFunctionSubEntity::getId, id)
        .one();
    return one;
  }

  /**
   * 根据ID，FunctionCode 查询一条信息
   *
   * @param id
   * @param functionCode
   * @return
   */
  public MdmFunctionSubEntity findByIdAndFunctionCode(String id, String functionCode) {
    MdmFunctionSubEntity one = this.lambdaQuery()
        .eq(MdmFunctionSubEntity::getId, id)
        .eq(MdmFunctionSubEntity::getFunctionCode, functionCode)
        .one();
    return one;
  }

  /**
   * 根据ID，查询 functionCode
   *
   * @param id
   * @return
   */
  public MdmFunctionSubEntity findFunctionCodeById(String id) {
    MdmFunctionSubEntity entity = this.lambdaQuery()
        .eq(MdmFunctionSubEntity::getId, id)
        .select(MdmFunctionSubEntity::getId, MdmFunctionSubEntity::getFunctionCode)
        .one();
    return entity;
  }

  /**
   * 根据 parentCode，functionCode 查询 id集合
   * hefan: 不应该能查询出多条。
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  public List<MdmFunctionSubEntity> findIdByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    List<MdmFunctionSubEntity> list = this.lambdaQuery()
        .eq(MdmFunctionSubEntity::getParentCode, parentCode)
        .eq(MdmFunctionSubEntity::getFunctionCode, functionCode)
        .select(MdmFunctionSubEntity::getId)
        .list();
    return list;
  }

  /**
   * 根据 id集合 查询 parentCode，functionCode
   *
   * @param ids
   */
  public List<MdmFunctionSubEntity> findParentCodeAndFunctionCodeByIdIn(List<String> ids) {
    List<MdmFunctionSubEntity> list = this.lambdaQuery()
        .in(MdmFunctionSubEntity::getId, ids)
        .select(MdmFunctionSubEntity::getParentCode, MdmFunctionSubEntity::getFunctionCode)
        .list();
    return list;
  }

  /**
   * 根据 id集合 修改 enableStatus(启用/禁用）
   *
   * @param ids
   * @param enableStatusCode
   */
  public void updateEnableStatusByIdIn(List<String> ids, String enableStatusCode) {
    this.lambdaUpdate()
        .in(MdmFunctionSubEntity::getId, ids)
        .set(MdmFunctionSubEntity::getEnableStatus, enableStatusCode)
        .update();
  }

  /**
   * 根据 parentCode，functionCode, functionType 查询
   * @param parentCode
   * @param functionCode
   * @param functionType
   * @return
   */
  public MdmFunctionSubEntity findOneByParentCodeAndFunctionCodeAndFunctionType(String parentCode, String functionCode, String functionType) {
    MdmFunctionSubEntity entity = this.lambdaQuery()
        .eq(MdmFunctionSubEntity::getParentCode, parentCode)
        .eq(MdmFunctionSubEntity::getFunctionType, functionType)
        .eq(MdmFunctionSubEntity::getFunctionCode, functionCode)
        .one();
    return entity;
  }

  /**
   * 根据 id 集合 查询
   * @param ids
   * @return
   */
  public List<MdmFunctionSubEntity> findByIdIn(List<String> ids) {
    List<MdmFunctionSubEntity> list = this.lambdaQuery()
        .in(MdmFunctionSubEntity::getId, ids)
        .list();
    return list;
  }
}
