package com.biz.crm.mdm.business.table.local.service;

import java.util.List;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigPersonalVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigPersonalVo;

/**
 * 专门用于Feign内部的接口
 * 
 * @author Ken.xu
 */
public interface ColumnConfigPersonalVoFeignService extends ColumnConfigPersonalVoService {
  /**
   * 入参： parentCode functionCode 当前登陆人的account信息
   * 返回：根据 个性化配置 过滤后的columnConfig
   * 
   * @param parentCode
   * @param functionCode
   * @param account
   * @param tenantCode
   * @return
   */
  List<ColumnConfigPersonalVo> findByParentCodeAndFunctionCodeForExport(
      String parentCode,
      String functionCode,
      String account,
      String tenantCode);
}
