package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.mdm.business.table.local.repository.ColumnConfigPersonalRepository;
import com.biz.crm.mdm.business.table.local.service.ColumnConfigPersonalService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author hefan
 */
@Service
public class ColumnConfigPersonalServiceImpl implements ColumnConfigPersonalService {

  @Autowired(required = false)
  private ColumnConfigPersonalRepository columnConfigPersonalRepository;

  @Transactional
  @Override
  public void deleteByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    Validate.notBlank(parentCode, "缺失菜单编码");
    Validate.notBlank(functionCode, "缺失功能编码");
    this.columnConfigPersonalRepository.deleteByParentCodeAndFunctionCode(parentCode, functionCode);
    // fixme: 原逻辑：清除缓存
  }
}
