package com.biz.crm.mdm.business.table.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubRepository;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubDto;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubPaginationDto;
import com.biz.crm.mdm.business.table.sdk.service.FunctionSubVoService;
import com.biz.crm.mdm.business.table.sdk.vo.FunctionSubVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

/**
 * @author hefan
 */
@Service
public class FunctionSubVoServiceImpl implements FunctionSubVoService {

  @Autowired(required = false)
  private FunctionSubRepository functionSubRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;


  @Override
  public Page<FunctionSubVo> findByCondition(Pageable pageable, FunctionSubPaginationDto functionSubPaginationDto) {
    if (Objects.isNull(functionSubPaginationDto)) {
      return null;
    }
    functionSubPaginationDto.setTenantCode(TenantUtils.getTenantCode());
    return functionSubRepository.findByCondition(pageable, functionSubPaginationDto);
  }

  @Override
  public List<FunctionSubVo> findByFunctionSubDto(FunctionSubDto functionSubDto) {

    return functionSubRepository.findByFunctionSubDto(functionSubDto);
  }

  @Override
  public FunctionSubVo findOneByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    Validate.notBlank(parentCode, "菜单编码不能为空");
    Validate.notBlank(functionCode, "功能编码不能为空");
    MdmFunctionSubEntity one = this.functionSubRepository.findOneByParentCodeAndFunctionCode(parentCode, functionCode);
    FunctionSubVo functionSubVo = this.nebulaToolkitService.copyObjectByBlankList(one, FunctionSubVo.class, HashSet.class, LinkedList.class);
    return functionSubVo;
  }

  @Override
  public FunctionSubVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MdmFunctionSubEntity one = this.functionSubRepository.findById(id);
    if (Objects.isNull(one)){
      return null;
    }
    FunctionSubVo functionSubVo = this.nebulaToolkitService.copyObjectByBlankList(one, FunctionSubVo.class, HashSet.class, LinkedList.class);
    return functionSubVo;
  }

  @Override
  public FunctionSubVo findByIdAndFunctionCode(String id, String functionCode) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    MdmFunctionSubEntity one = this.functionSubRepository.findByIdAndFunctionCode(id, functionCode);
    if (Objects.isNull(one)){
      return null;
    }
    FunctionSubVo functionSubVo = this.nebulaToolkitService.copyObjectByBlankList(one, FunctionSubVo.class, HashSet.class, LinkedList.class);
    return functionSubVo;
  }
}
