/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubButtonRepository;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubRepository;
import com.biz.crm.mdm.business.table.sdk.enums.PageTemplateTypeEnum;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigPersonalVoService;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigVoService;
import com.biz.crm.mdm.business.table.sdk.service.TableConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ButtonConfigVo;
import com.biz.crm.mdm.business.table.sdk.vo.TableConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.competence.sdk.service.ButtonVoService;
import com.bizunited.nebula.competence.sdk.vo.ButtonVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TableConfigVoServiceImpl
implements TableConfigVoService {
    @Autowired(required=false)
    private FunctionSubRepository functionSubRepository;
    @Autowired(required=false)
    private FunctionSubButtonRepository functionSubButtonRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ButtonVoService buttonVoService;
    private static final String ROLE_ADMIN = "ADMIN";
    @Autowired(required=false)
    private ColumnConfigVoService columnConfigVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ColumnConfigPersonalVoService columnConfigPersonalVoService;

    public TableConfigVo findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MdmFunctionSubEntity functionSubEntity = this.functionSubRepository.findOneByParentCodeAndFunctionCodeAndFunctionType(parentCode, functionCode, PageTemplateTypeEnum.LIST_CONFIG.getCode());
        Validate.notNull((Object)((Object)functionSubEntity), (String)"\u5217\u8868\u914d\u7f6e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        TableConfigVo resultRespVo = this.findListConfig(parentCode, functionCode);
        resultRespVo.setUrl(functionSubEntity.getApiUrl());
        resultRespVo.setResizable(Boolean.valueOf(true));
        return resultRespVo;
    }

    private TableConfigVo findListConfig(String parentCode, String functionCode) {
        String showMode = BooleanEnum.TRUE.getNumStr();
        List<Object> functionSubButton = this.functionSubButtonRepository.findButtonByParentCodeAndFunctionCodeAndVisible(parentCode, functionCode, showMode);
        Set<String> roleCodes = this.findUserRoleCodeSet();
        if (CollectionUtils.isEmpty(roleCodes)) {
            functionSubButton = Lists.newLinkedList();
        } else if (!roleCodes.contains(ROLE_ADMIN)) {
            String[] competenceCodes = new String[]{StringUtils.joinWith((String)"@", (Object[])new Object[]{parentCode, functionCode})};
            String[] roleArr = roleCodes.toArray(new String[0]);
            List roleButtons = this.buttonVoService.findByRoleCodesAndCompetenceCodes(roleArr, competenceCodes);
            if (CollectionUtils.isEmpty((Collection)roleButtons)) {
                functionSubButton = Lists.newLinkedList();
            } else {
                Set buttonCodes = roleButtons.stream().map(ButtonVo::getCode).collect(Collectors.toSet());
                List cur = functionSubButton.stream().filter(a -> buttonCodes.contains(a.getCode())).collect(Collectors.toList());
                functionSubButton = cur;
                Map<String, ButtonVo> map = roleButtons.stream().collect(Collectors.toMap(ButtonVo::getCode, buttonVo -> buttonVo));
            }
        }
        List columnConfigVos = this.columnConfigVoService.findByParentCodeAndFunctionCodeOrderByFormorder(parentCode, functionCode);
        List<ButtonConfigVo> buttonConfigVos = this.copyFuctionSubButton2ButtonCofigVo(functionSubButton);
        List columnConfigPersonalVos = this.columnConfigPersonalVoService.findByParentCodeAndFunctionCode(parentCode, functionCode);
        TableConfigVo tableConfigVo = new TableConfigVo();
        tableConfigVo.setColumn(columnConfigVos);
        tableConfigVo.setColumnPersonal(columnConfigPersonalVos);
        tableConfigVo.setButtonVos(buttonConfigVos);
        return tableConfigVo;
    }

    private List<ButtonConfigVo> copyFuctionSubButton2ButtonCofigVo(List<MdmFunctionSubButtonEntity> functionSubButton) {
        LinkedList buttonConfigVos = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty(functionSubButton)) {
            for (MdmFunctionSubButtonEntity entity : functionSubButton) {
                ButtonConfigVo buttonConfigVo = (ButtonConfigVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, ButtonConfigVo.class, HashSet.class, LinkedList.class, new String[0]);
                buttonConfigVos.add(buttonConfigVo);
            }
        }
        return buttonConfigVos;
    }

    private Set<String> findUserRoleCodeSet() {
        Authentication authentication = this.loginUserService.getAuthentication();
        Validate.notNull((Object)authentication, (String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f", (Object[])new Object[0]);
        Collection authorities = authentication.getAuthorities();
        if (CollectionUtils.isEmpty((Collection)authorities)) {
            return Sets.newHashSet();
        }
        HashSet set = Sets.newHashSet();
        for (GrantedAuthority item : authorities) {
            String role = item.getAuthority();
            if (StringUtils.isBlank((CharSequence)role)) continue;
            set.add(role);
        }
        return set;
    }
}

