package com.biz.crm.mdm.business.table.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigSelectVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigSelectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author hefan
 */
@Api(tags = "页面引擎：ColumnConfig: 字段配置")
@Slf4j
@RestController
@RequestMapping("/v1/table/columnConfig")
public class ColumnConfigSelectVoController {

  @Autowired(required = false)
  private ColumnConfigSelectVoService columnConfigSelectVoService;


  /**
   * hefan:
   * 根据 parentCode functionCode 【columnExport】查询 字段配置
   *
   * @param parentCode
   * @param functionCode
   * @param columnExport
   * @return
   */
  @ApiOperation("字段下拉框")
  @GetMapping("/findByParentCodeAndFunctionCodeAndColumnExportOpt")
  public Result<List<ColumnConfigSelectVo>> findByParentCodeAndFunctionCodeAndColumnExportOpt(@ApiParam(name = "parentCode", value = "上级菜单") String parentCode,
                                                                                              @ApiParam(name = "functionCode", value = "菜单") String functionCode,
                                                                                              @ApiParam(name = "columnExport", value = "是否导出") String columnExport) {
    try {
      List<ColumnConfigSelectVo> list = this.columnConfigSelectVoService.findByParentCodeAndFunctionCodeAndColumnExportOpt(parentCode, functionCode, columnExport);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
