package com.biz.crm.mdm.business.table.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.sdk.dto.PermissionObjDto;
import com.biz.crm.mdm.business.table.sdk.service.PermissionObjVoService;
import com.biz.crm.mdm.business.table.sdk.vo.PermissionObjVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 可能是权限对象，配置在字典里的
 *
 * @author hefan
 */
@Api(tags = "页面引擎：PermissionObjVo：可能是权限对象，配置在字典里的")
@Slf4j
@RestController
@RequestMapping("/v1/table/permissionObj")
public class PermissionObjVoController {

  @Autowired(required = false)
  private PermissionObjVoService permissionObjVoService;

  /**
   * hefan: 根据 上级菜单编码  下级菜单编码 查询已配置的权限对象
   */
  @ApiOperation("根据列表编码和菜单编码查询已配置的权限对象")
  @PostMapping("/findByParentCodeAndFunctionCode")
  public Result<List<PermissionObjVo>> findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    try {
      List<PermissionObjVo> list = this.permissionObjVoService.findByParentCodeAndFunctionCode(parentCode, functionCode);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * hefan: 权限对象范围列表保存
   * @param permissionObjDto
   * @return
   */
  @ApiOperation("权限对象范围列表保存")
  @PostMapping("")
  public Result<?> create(@RequestBody PermissionObjDto permissionObjDto) {
    try {
      this.permissionObjVoService.create(permissionObjDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
