package com.biz.crm.mdm.business.table.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.sdk.service.TableConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.TableConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * hefan:
 *
 * @author hefan
 * @date 2020-11-21 14:25:32
 */
@Api(tags = "页面引擎：TableConfigVo: 右侧列表配置")
@Slf4j
@RestController
@RequestMapping("/v1/table/tableConfig")
public class TableConfigVoController {

  @Autowired(required = false)
  private TableConfigVoService tableConfigVoService;

  /**
   * hefan:
   *  入参： parentCode functionCode
   *  返回对象内包含：
   *    角色权限内的按钮信息
   *    页面引擎主表【页面模板】的字段信息
   *    apiUrl
   *  返回的对象字段按照个性化字段配置排序、赋值可见性
   *
   * @param parentCode
   * @param functionCode
   * @return
   */
  @ApiOperation(value = "根据菜单编码和功能编码查询列表配置")
  @GetMapping("/findByParentCodeAndFunctionCode")
  public Result<TableConfigVo> findByParentCodeAndFunctionCode(String parentCode, String functionCode) {
    try {
      TableConfigVo vo = this.tableConfigVoService.findByParentCodeAndFunctionCode(parentCode, functionCode);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }





}
