package com.biz.crm.mdm.business.table.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Set;

/**
 * hefan：
 * functionSub 就是页面引擎产出的 列表，表单 等；归纳为：页面模板（PageTemplate)
 * 这个系统里，对其存在的注释为 下级菜单、功能。
 * <p>
 * 下级菜单表实体类
 *
 * @author zxw
 * @date 2020-11-21 00:22:17
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmFunctionSubEntity", description = "下级菜单表实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`mdm_function_sub`", comment = "下级菜单表实体类")
@TableName("mdm_function_sub")
@Table(name = "`mdm_function_sub`", indexes = {
    @Index(name = "uk_parent_code_function_code", columnList = "parent_code,function_code", unique = true)
})
public class MdmFunctionSubEntity extends TenantFlagOpEntity {

  /**
   * 功能编码 = parentCode + @ + functionCode
   */
  @ApiModelProperty("功能编码 = parentCode + @ + functionCode")
  @Column(name = "code", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 功能编码 = parentCode + @ + functionCode '")
  private String code;

  /**
   * 下级菜单编码
   */
  @ApiModelProperty("下级菜单编码")
  @Column(name = "function_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 下级菜单编码 '")
  private String functionCode;

  /**
   * 下级菜单名称
   */
  @ApiModelProperty("下级菜单名称")
  @Column(name = "function_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 下级菜单名称 '")
  private String functionName;

  /**
   * 上级菜单编码
   */
  @ApiModelProperty("上级菜单编码")
  @Column(name = "parent_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 上级菜单编码 '")
  private String parentCode;

  /**
   * 菜单类型
   */
  @ApiModelProperty("菜单类型")
  @Column(name = "function_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 菜单类型 '")
  private String functionType;

  /**
   * url
   */
  @ApiModelProperty("url")
  @Column(name = "api_url", nullable = true, length = 200, columnDefinition = "VARCHAR(200) COMMENT ' url '")
  private String apiUrl;

  /**
   * api url 请求映射
   */
  @ApiModelProperty("apiUrlRequestMapping")
  @Column(name = "api_url_request_mapping", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT ' api url 请求映射方式 '")
  private String apiUrlRequestMapping;

  /**
   * 字段来源
   * （数据试图、或者其他）
   */
  @ApiModelProperty("configSource")
  @Column(name = "config_source", nullable = true, length = 50, columnDefinition = "VARCHAR(50) COMMENT ' 字段来源 '")
  private String configSource;

  /**
   * 字段来源名称
   * （数据试图、或者其他）
   */
  @ApiModelProperty("configSourceName")
  @Column(name = "config_source_name", nullable = true, length = 100, columnDefinition = "VARCHAR(100) COMMENT ' 字段来源名称 '")
  private String configSourceName;

  /**
   * 字段来源之子系统
   *
   */
  @ApiModelProperty("systemOfConfigSource")
  @Column(name = "system_of_config_source", nullable = true, length = 50, columnDefinition = "VARCHAR(50) COMMENT ' 字段来源之子系统 '")
  private String systemOfConfigSource;

  /**
   * vo名称
   */
  @ApiModelProperty("vo名称")
  @Column(name = "vo_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' vo名称 '")
  private String voName;

  /**
   * 权限对象配置，以逗号隔开
   */
  @ApiModelProperty("权限对象配置，以逗号隔开")
  @Column(name = "permission_obj", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 权限对象配置，以逗号隔开 '")
  private String permissionObj;

  /**
   * 字段配置实体类
   */
  @ApiModelProperty("字段配置实体类")
  @Transient
  @TableField(exist = false)
  private Set<MdmColumnConfigEntity> columnConfigEntities;


}
