package com.biz.crm.mdm.business.table.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.business.table.local.mapper.FunctionSubButtonMapper;
import com.biz.crm.mdm.business.table.sdk.vo.ButtonConfigVo;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author hefan
 */
@Component
public class FunctionSubButtonRepository extends ServiceImpl<FunctionSubButtonMapper, MdmFunctionSubButtonEntity> {

  /**
   * 移除，根据 parentCode,functionCode,buttonCode;
   *
   * @param mdmFunctionSubButtonEntity
   */
  public void deleteByParentCodeAndFunctionCodeAndButtonCode(MdmFunctionSubButtonEntity mdmFunctionSubButtonEntity) {
    this.lambdaUpdate()
        .eq(MdmFunctionSubButtonEntity::getParentCode, mdmFunctionSubButtonEntity.getParentCode())
        .eq(MdmFunctionSubButtonEntity::getFunctionCode, mdmFunctionSubButtonEntity.getFunctionCode())
        .eq(MdmFunctionSubButtonEntity::getCode, mdmFunctionSubButtonEntity.getCode())
        .remove();
  }

  /**
   * 查询集合，根据ID集合
   * @param ids
   * @return
   */
  public List<MdmFunctionSubButtonEntity> findByIdIn(List<String> ids) {
    List<MdmFunctionSubButtonEntity> list = this.lambdaQuery()
        .in(MdmFunctionSubButtonEntity::getId, ids)
        .list();
    return list;
  }

  /**
   * 根据 parentCode，functionCodeDB，修改functionCode
   * @param parentCode
   * @param functionCodeDB
   * @param functionCode
   */
  public void updateFunctionCodeByParentCodeAndFunctionCode(String parentCode, String functionCodeDB, String functionCode) {
    this.lambdaUpdate()
        .eq(MdmFunctionSubButtonEntity::getParentCode, parentCode)
        .eq(MdmFunctionSubButtonEntity::getFunctionCode, functionCodeDB)
        .set(MdmFunctionSubButtonEntity::getFunctionCode, functionCode)
        .update();
  }

  /**
   * 根据 parentCode集合，functionCode集合删除
   * @param parentCodeList
   * @param functionCodeList
   */
  public void deleteByParentCodeInAndFunctionCodeIn(List<String> parentCodeList, List<String> functionCodeList) {
    this.lambdaUpdate()
        .in(MdmFunctionSubButtonEntity::getParentCode, parentCodeList)
        .in(MdmFunctionSubButtonEntity::getFunctionCode, functionCodeList)
        .remove();
  }

  /**
   * 根据 parentCode，functionCode，visible 查询按钮信息
   * @param parentCode
   * @param functionCode
   * @param visible
   * @return
   */
  public List<MdmFunctionSubButtonEntity> findButtonByParentCodeAndFunctionCodeAndVisible(String parentCode, String functionCode, String visible) {
    List<MdmFunctionSubButtonEntity> functionSubButtonEntity = this.baseMapper.findButtonByParentCodeAndFunctionCodeAndVisible(parentCode, functionCode, visible);
    return functionSubButtonEntity;
  }

  /**
   * 根据 parentCode，functionCode 查询按钮信息
   * 分页
   * @param parentCode
   * @param functionCode
   * @return
   */
  public Page<MdmFunctionSubButtonEntity> findButtonPageByParentCodeAndFunctionCode(Pageable pageable, String parentCode, String functionCode) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    Page<MdmFunctionSubButtonEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findButtonPageByParentCodeAndFunctionCode(page,parentCode, functionCode);
  }

  /**
   * 根据 parentCode，functionCode 查询按钮信息
   * @param parentCode
   * @param functionCode
   * @return
   */
  public List<MdmFunctionSubButtonEntity> findButtonByParentCodeAndFunctionCode( String parentCode, String functionCode) {
    return this.baseMapper.findButtonByParentCodeAndFunctionCode(parentCode, functionCode);
  }

  /**
   * 根据 id 查询按钮信息
   * @param id
   * @return
   */
  public MdmFunctionSubButtonEntity findButtonById(String id) {
    MdmFunctionSubButtonEntity entity = this.baseMapper.findButtonById(id);
    return entity;
  }

  /**
   * 根据 code tenantCode查询一条
   * @param code
   * @param tenantCode
   * @return
   */
  public MdmFunctionSubButtonEntity findByCode(String code, String tenantCode) {
    return this.lambdaQuery()
        .eq(MdmFunctionSubButtonEntity::getCode, code)
        .eq(MdmFunctionSubButtonEntity::getTenantCode, tenantCode)
        .one();
  }

  public List<MdmFunctionSubButtonEntity> findByCodeIn(List<String> codes, String tenantCode) {
    return this.lambdaQuery()
        .in(MdmFunctionSubButtonEntity::getCode, codes)
        .eq(MdmFunctionSubButtonEntity::getTenantCode, tenantCode)
        .list();
  }
}
