/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.table.local.service.internal;

import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubButtonEntity;
import com.biz.crm.mdm.business.table.local.entity.MdmFunctionSubEntity;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubButtonRepository;
import com.biz.crm.mdm.business.table.local.repository.FunctionSubRepository;
import com.biz.crm.mdm.business.table.local.service.FunctionSubButtonService;
import com.biz.crm.mdm.business.table.sdk.dto.FunctionSubButtonDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.competence.sdk.service.CompetenceButtonMappingService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import jodd.util.ArraysUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FunctionSubButtonServiceImpl
implements FunctionSubButtonService {
    @Autowired(required=false)
    private FunctionSubButtonRepository functionSubButtonRepository;
    @Autowired(required=false)
    private FunctionSubRepository functionSubRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CompetenceButtonMappingService competenceButtonMappingService;

    @Override
    @Transactional
    public MdmFunctionSubButtonEntity create(FunctionSubButtonDto functionSubButtonDto) {
        MdmFunctionSubButtonEntity mdmFunctionSubButtonEntity = (MdmFunctionSubButtonEntity)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)functionSubButtonDto, MdmFunctionSubButtonEntity.class, HashSet.class, LinkedList.class, new String[0]));
        return this.create(mdmFunctionSubButtonEntity);
    }

    @Override
    @Transactional
    public MdmFunctionSubButtonEntity create(MdmFunctionSubButtonEntity entity) {
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.createValidation(entity);
        this.functionSubButtonRepository.save((Object)entity);
        String code = entity.getCode();
        MdmFunctionSubEntity functionSubEntity = this.functionSubRepository.findOneByParentCodeAndFunctionCode(entity.getParentCode(), entity.getFunctionCode());
        String competenceCode = functionSubEntity.getCode();
        String[] array = (String[])ArraysUtil.array((Object[])new String[]{competenceCode});
        this.competenceButtonMappingService.bindButton(code, array);
        return entity;
    }

    @Override
    @Transactional
    public MdmFunctionSubButtonEntity update(MdmFunctionSubButtonEntity entity) {
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.updateValidation(entity);
        this.functionSubButtonRepository.updateById((Object)entity);
        return entity;
    }

    private void updateValidation(MdmFunctionSubButtonEntity mdmFunctionSubButtonEntity) {
        Validate.notNull((Object)((Object)mdmFunctionSubButtonEntity), (String)"\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubButtonEntity.getId(), (String)"\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubButtonEntity.getParentCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubButtonEntity.getFunctionCode(), (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubButtonEntity.getButtonCode(), (String)"\u524d\u7aef\u6309\u94ae\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubButtonEntity.getCode(), (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void deleteByIdIn(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<MdmFunctionSubButtonEntity> list = this.functionSubButtonRepository.findByIdIn(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u6570\u636e\u9700\u8981\u5220\u9664", (Object[])new Object[0]);
        this.functionSubButtonRepository.removeByIds(ids);
    }

    @Override
    public MdmFunctionSubButtonEntity findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.functionSubButtonRepository.findByCode(code, TenantUtils.getTenantCode());
    }

    @Override
    public MdmFunctionSubButtonEntity findById(String pageEngineButtonId) {
        if (StringUtils.isBlank((CharSequence)pageEngineButtonId)) {
            return null;
        }
        return (MdmFunctionSubButtonEntity)((Object)this.functionSubButtonRepository.getById((Serializable)((Object)pageEngineButtonId)));
    }

    private void createValidation(MdmFunctionSubButtonEntity mdmFunctionSubButtonEntity) {
        Validate.notNull((Object)((Object)mdmFunctionSubButtonEntity), (String)"\u5165\u53c2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubButtonEntity.getParentCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubButtonEntity.getFunctionCode(), (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubButtonEntity.getButtonCode(), (String)"\u524d\u7aef\u6309\u94ae\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmFunctionSubButtonEntity.getCode(), (String)"\u6309\u94ae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.functionSubButtonRepository.deleteByParentCodeAndFunctionCodeAndButtonCode(mdmFunctionSubButtonEntity);
    }
}

